% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd.decomp.R
\name{plot.bgvar.fevd}
\alias{plot.bgvar.fevd}
\title{Plotting Function for Forecast Error Variance Decomposition}
\usage{
\method{plot}{bgvar.fevd}(x, ..., ts, k.max = 10)
}
\arguments{
\item{x}{an object of class \code{bgvar.fevd}.}

\item{...}{additional arguments.}

\item{ts}{specify the decomposed time series to be plotted.}

\item{k.max}{plots the k series with the highest for the decomposition of \code{ts}.}
}
\value{
No return value.
}
\description{
Plots the decomposition of a specific time series into selected structural shocks.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,saves=100,burns=100,plag=1,
                      prior="SSVS",thin=1,eigen=TRUE)
                      
# US monetary policy shock
shocks<-list();shocks$var="stir";shocks$cN<-"US";shocks$ident="chol";shocks$scal=-100
irf.chol.us.mp<-IRF(obj=model.ssvs.eer,shock=shocks,nhor=48)

# calculates FEVD for variables US.Dp and EA.y
fevd.us.mp=fevd.decomp(obj=irf.chol.us.mp,var.slct=c("US.Dp","EA.y"))

plot(fevd.us.mp, ts="US.Dp", k.max=10)
}
}
\seealso{
\code{\link{IRF}}
}
\author{
Maximilian Boeck
}
