% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{DIC}
\alias{DIC}
\title{Deviance Information Criterion}
\usage{
DIC(object, ...)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}
}
\value{
Returns a numeric value with the corresponding DIC.
}
\description{
Computes the Deviance information criterion for an object \code{bgvar}.
}
\examples{
\dontshow{
library(BGVAR)
data(eerData)
cN<-c("EA","US","UK")
eerData<-eerData[cN]
W.trade0012<-apply(W.trade0012[cN,cN],2,function(x)x/rowSums(W.trade0012[cN,cN]))
model.mn <- bgvar(Data=eerData,W=W.trade0012,plag=2,saves=100,burns=100,prior="MN")
DIC(model.mn)
}
\donttest{
set.seed(1)
library(BGVAR)
data(eerData)
model.mn <- bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100,prior="MN")
DIC(model.mn)
}
}
\references{
Spiegelhalter, D. J. and Best, N. G., Carlin, B. P. and Linde, A. (2002) \emph{Bayesian measures of model complexity and fit.} Journal of the Royal Statistical Society, Series B, Vol. 64(4), pp. 583-639.
}
\author{
Maximilian Boeck
}
