% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.bgvar}
\alias{plot.bgvar.resid}
\alias{plot.bgvar.pred}
\alias{plot.bgvar.irf}
\alias{plot.bgvar.fevd}
\title{Graphical summary of output created with \code{bgvar}}
\usage{
\method{plot}{bgvar}(x, ..., resp = NULL, global = TRUE)

\method{plot}{bgvar.resid}(x, ..., resp = NULL, global = TRUE)

\method{plot}{bgvar.pred}(x, ..., resp = NULL, Cut = 40)

\method{plot}{bgvar.irf}(x, ..., resp = NULL, shock.nr = 1, cumulative = FALSE)

\method{plot}{bgvar.fevd}(x, ..., resp, k.max = 10)
}
\arguments{
\item{x}{either an object of class \code{bgvar}, \code{bgvar.res}, \code{bgvar.irf}, \code{bgvar.predict} or \code{bgvar.fevd}.}

\item{...}{additional arguments.}

\item{resp}{specify a variable to plot predictions.}

\item{global}{if \code{TRUE} global residuals are plotted, otherwise country residuals.}

\item{Cut}{length of series to be plotted before prediction begins.}

\item{shock.nr}{specify shock to be plotted.}

\item{cumulative}{whether cumulative impulse response functions should be plotted. Default is set to \code{FALSE}.}

\item{k.max}{plots the k series with the highest for the decomposition of \code{resp}.}
}
\value{
No return value.
}
\description{
Plotting function for fitted values, residuals, predictions, impulse responses and forecast error variance decompositions created with the \code{BGVAR} package.
}
\examples{
\dontshow{
cN<-c("EA","US","UK")
eerData<-eerData[cN]
W.trade0012<-apply(W.trade0012[cN,cN],2,function(x)x/rowSums(W.trade0012[cN,cN]))}
model.ssvs <- bgvar(Data=eerData,W=W.trade0012,plag=1,draws=100,burnin=100,
                    prior="SSVS")
\donttest{
# example for class 'bgvar'
plot(model.ssvs, resp="EA")
}
\donttest{
# example for class 'bgvar.resid'
res <- residuals(model.ssvs)
plot(res, resp="EA")
}
\donttest{
# example for class 'bgvar.pred'
fcast <- predict(model.ssvs,n.ahead=8,save.store=TRUE)
plot(fcast, resp="US.Dp", Cut=20)
}
\donttest{
# example for class 'bgvar.irf'
shocks<-list();shocks$var="stir";shocks$cN<-"US";shocks$ident="chol";shocks$scal=-100
irf.chol.us.mp<-irf(model.ssvs,shock=shocks,n.ahead=24)
plot(irf.chol.us.mp,resp="US.y")
}
\donttest{
# example for class 'bgvar.fevd'
fevd.us.mp=fevd(irf.chol.us.mp,var.slct=c("US.Dp","EA.y"))
plot(fevd.us.mp, resp="US.Dp", k.max=10)
}
}
\author{
Maximilian Boeck, Martin Feldkircher
}
