% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPedigree.R
\name{readGedcom}
\alias{readGedcom}
\title{Read a GEDCOM File}
\usage{
readGedcom(
  file_path,
  verbose = FALSE,
  add_parents = TRUE,
  remove_empty_cols = TRUE,
  combine_cols = TRUE,
  skinny = FALSE
)
}
\arguments{
\item{file_path}{The path to the GEDCOM file.}

\item{verbose}{A logical value indicating whether to print messages.}

\item{add_parents}{A logical value indicating whether to add parents to the data frame.}

\item{remove_empty_cols}{A logical value indicating whether to remove columns with all missing values.}

\item{combine_cols}{A logical value indicating whether to combine columns with duplicate values.}

\item{skinny}{A logical value indicating whether to return a skinny data frame.}
}
\value{
A data frame containing information about individuals, with the following potential columns:
- `id`: ID of the individual
- `momID`: ID of the individual's mother
- `dadID`: ID of the individual's father
- `sex`: Sex of the individual
- `name`: Full name of the individual
- `name_given`: First name of the individual
- `name_surn`: Last name of the individual
- `name_marriedsurn`: Married name of the individual
- `name_nick`: Nickname of the individual
- `name_npfx`: Name prefix
- `name_nsfx`: Name suffix
- `birth_date`: Birth date of the individual
- `birth_lat`: Latitude of the birthplace
- `birth_long`: Longitude of the birthplace
- `birth_place`: Birthplace of the individual
- `death_caus`: Cause of death
- `death_date`: Death date of the individual
- `death_lat`: Latitude of the place of death
- `death_long`: Longitude of the place of death
- `death_place`: Place of death of the individual
- `attribute_caste`: Caste of the individual
- `attribute_children`: Number of children of the individual
- `attribute_description`: Description of the individual
- `attribute_education`: Education of the individual
- `attribute_idnumber`: Identification number of the individual
- `attribute_marriages`: Number of marriages of the individual
- `attribute_nationality`: Nationality of the individual
- `attribute_occupation`: Occupation of the individual
- `attribute_property`: Property owned by the individual
- `attribute_religion`: Religion of the individual
- `attribute_residence`: Residence of the individual
- `attribute_ssn`: Social security number of the individual
- `attribute_title`: Title of the individual
- `FAMC`: ID(s) of the family where the individual is a child
- `FAMS`: ID(s) of the family where the individual is a spouse
}
\description{
This function reads a GEDCOM file and parses it into a structured data frame of individuals.
Inspired by https://raw.githubusercontent.com/jjfitz/readgedcom/master/R/read_gedcom.R
}
