% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeE.R
\name{computeE}
\alias{computeE}
\title{Retrieving Chave's environmental index}
\usage{
computeE(coord)
}
\arguments{
\item{coord}{Coordinates of the site(s), a matrix/dataframe with two columns (e.g. cbind(longitude, latitude)) (see examples).}
}
\value{
The function returns \code{E}, the environmental index computed thanks to the Chave et al 2014's formula.
}
\description{
Extract the Chave et al. 2014's environmental index thanks to the coordinates of the data.
The function is time-consuming at its first use as it downloads a raster in a folder (see Details).
However, as soon as the raster is downloaded once, the function then runs fast.
}
\details{
The Chave's environmental index, \code{E}, has been shown to be an important covariable in
the diameter-height relationship for tropical trees. It is calculated as:
\deqn{E = 1.e-3 * (0.178 * TS - 0.938 * CWD - 6.61 * PS)}
where \code{TS} is temperature seasonality as defined in the Worldclim dataset (bioclimatic variable 4),
\code{CWD} is the climatic water deficit (in mm/yr, see Chave et al. 2014) and \code{PS} is the
precipitation seasonality as defined in the Worldclim dataset (bioclimatic variable 15).

The E index is extracted from a raster file (2.5 arc-second resolution, or ca. 5 km) available
at http://chave.ups-tlse.fr/pantropical_allometry.htm
}
\section{Localisation}{

The localisation of the folder is :
\itemize{
\item On Linux : \verb{~/.local/share/R/BIOMASS}
\item On Mac OS X : \verb{~/Library/Application Support/R/BIOMASS}
\item On Windows 7 up to 10 : \verb{C:\\\\Users\\\\<username>\\\\AppData\\\\Local\\\\R\\\\BIOMASS\\\\R\\\\BIOMASS}
\item On Windows XP : \verb{C:\\\\Documents and Settings\\\\<username>\\\\Data\\\\R\\\\BIOMASS\\\\R\\\\BIOMASS}
}

See this function for more information : \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}
}

\examples{
# One study site
lat <- 4.08
long <- -52.68
coord <- cbind(long, lat)
\dontrun{
E <- computeE(coord)
}

# Several study sites (here three sites)
long <- c(-52.68, -51.12, -53.11)
lat <- c(4.08, 3.98, 4.12)
coord <- cbind(long, lat)
\dontrun{
E <- computeE(coord)
}

}
\references{
Chave et al. (2014) \emph{Improved allometric models to estimate the aboveground biomass of tropical trees},
Global Change Biology, 20 (10), 3177-3190
}
\author{
Jerome CHAVE, Maxime REJOU-MECHAIN, Ariane TANGUY, Arthur PERE
}
\keyword{environmental}
\keyword{index}
\keyword{internal}
