% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGrid.r
\name{drawPolygon}
\alias{drawPolygon}
\title{Create the polygon for the study area by drawing into a world map}
\usage{
drawPolygon(lat = 0, lng = 0, zoom = 1, editor = "leafpm")
}
\arguments{
\item{lat}{initial geographical coordinate for latititude in decimal degrees (EPSG:4326)
for the map to start at. Default = \dQuote{0}.}

\item{lng}{initial geographical coordinate for longitude in decimal degrees (EPSG:4326)
for the map to start at. Default = \dQuote{0}.}

\item{zoom}{initial zoom level for the map. Range 1 - 19. Default = \dQuote{1}.}

\item{editor}{type of editor for the drawing tools. Options are \dQuote{leafpm} (default)
and \dQuote{leaflet.extras}. Requires additional packages \code{leafpm} and
\code{leaflet.extras}, respectively.}
}
\value{
an object of class \sQuote{SpatialPolygon-class} with a polygon
(only the first one drawn) with geodesic coordinates in WGS84 (ESPG:4326).
}
\description{
Create the polygon for the study area by drawing into a world map
}
\examples{
if(interactive()){
 polygon <- drawPolygon()
}
}
