% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_heatmap_mix_param}
\alias{get_heatmap_mix_param}
\title{Duration Times Plot: Heat-map of Mixture Gamma Shape & Rate Parameters}
\usage{
get_heatmap_mix_param(results, decimal_pts = 2, include_plot = TRUE)
}
\arguments{
\item{results}{results of duration times, i.e., results$results_duration}

\item{decimal_pts}{specify the number of decimal points of the results; default is 2}

\item{include_plot}{display plot if TRUE; default is TRUE}
}
\value{
No return value, called for printing and plotting heatmaps for mixture parameters.
}
\description{
Print and plot the heat-map for the gamma mixture parameters for each component
}
\details{
Print a matrix of size K*2, where K is the number of components.
Each row i represents the shape and rate parameter of component i.
}
\examples{
results <- BMRMM(foxp2_sm,num_cov=2,simsize=50)
get_heatmap_mix_param(results$results_duration)

}
