% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocs_exp_nocovar.R
\name{ocs_exp_nocovar}
\alias{ocs_exp_nocovar}
\title{Determine operating characteristics of fits from two-arm trials with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event}
\usage{
ocs_exp_nocovar(multiple_fits, d_params, m_params)
}
\arguments{
\item{multiple_fits}{List of model fits from \code{fit_mult_exp_nocovar}.}

\item{d_params}{List of data parameters as used in \code{sim_dat_one_trial_exp_nocovar}.}

\item{m_params}{List of model parameters as used in \code{fit_single_exp_nocovar}.}
}
\value{
A list of length 3, containing objects call \code{ocs}, \code{d_params}, \code{m_params}, where \code{ocs} is a \code{tibble} containing averaged parameter estimates and operating characteristics, and \code{d_params} and \code{m_params} are the objects supplied to the function.
}
\description{
Determine operating characteristics of fits from two-arm trials with an exponentially distributed time-to-event endpoint and no predictor of the intercurrent event
}
\details{
This function is used in \code{run_sim_exp_nocovar()}, the output of the two functions is the same.
}
\examples{
d_params_nocovar <- list(
  n = 500L,
  nt = 250L,
  prob_ice = 0.5,
  fu_max = 336L,
  T0T_rate = 0.2,
  T0N_rate = 0.2,
  T1T_rate = 0.15,
  T1N_rate = 0.1
)
dat_mult_trials <- sim_dat_mult_trials_exp_nocovar(
  n_iter = 2,
  params = d_params_nocovar 
)
m_params_nocovar <- list(
  tg = 48L,
  prior_piT = c(0.5, 0.5),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2L,
  n_iter = 3000L,
  warmup = 1500L,
  cores = 2L,
  open_progress = FALSE,
  show_messages = TRUE  
)
\donttest{
fit_multiple <- fit_mult_exp_nocovar(
  dat_mult_trials = dat_mult_trials,
  params = m_params_nocovar,
  seed = 12
)
list_ocs <- ocs_exp_nocovar(
  multiple_fits = fit_multiple, 
  d_params = d_params_nocovar, 
  m_params = m_params_nocovar
)
print(list_ocs)
}
}
\seealso{
\code{\link[=ocs_exp_covar]{ocs_exp_covar()}} and \code{\link[=run_sim_exp_nocovar]{run_sim_exp_nocovar()}}.
}
