% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinkFunction_Selection.R
\name{Select_link_BivCop}
\alias{Select_link_BivCop}
\title{Select Best Link Function for Bivariate Copula Survival Models}
\usage{
Select_link_BivCop(
  data,
  cens1,
  cens2,
  lowerBt1 = "t11",
  lowerBt2 = "t21",
  upperBt1 = "t12",
  upperBt2 = "t22",
  measure = "AIC",
  eta1 = NULL,
  eta2 = NULL,
  input_equation = FALSE
)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{cens1}{Censoring indicator for the first time to event.}

\item{cens2}{Censoring indicator for the second time to event.}

\item{lowerBt1}{Character. Name of the lower bound for the first time to event.}

\item{lowerBt2}{Character. Name of the lower bound for the second time to event.}

\item{upperBt1}{Character. Name of the upper bound for the first time to event.}

\item{upperBt2}{Character. Name of the upper bound for the second time to event.}

\item{measure}{Character. Measure to be minimized during the selection process. Either 'AIC' or 'BIC'. Default is 'AIC'.}

\item{eta1}{Formula for the first survival model equation. Default is NULL.}

\item{eta2}{Formula for the second survival model equation. Default is NULL.}

\item{input_equation}{Logical. If TRUE, uses the provided \code{eta1} and \code{eta2} formulas. If FALSE, generates formulas using all predictors in \code{data}. Default is FALSE.}
}
\value{
A list containing:
\itemize{
\item \code{best_margin_S1}: The best margin (link function) for the first survival model.
\item \code{measure}: The AIC or BIC value for the best margin of the first survival model.
\item \code{model_S1}: The fitted model for the first survival model with the best margin.
\item \code{best_margin_S2}: The best margin (link function) for the second survival model.
\item \code{measure_S2}: The AIC or BIC value for the best margin of the second survival model.
\item \code{model_S2}: The fitted model for the second survival model with the best margin.
}
}
\description{
Selects the best link function for bivariate copula survival models based on AIC or BIC measures.
It evaluates different margins (link functions) for the survival models and selects the one with the lowest AIC or BIC.
}
\examples{
\donttest{
###############################################
# Example based on AREDS dataset
# This analysis serves solely as a
# demonstration of the function's capabilities.
###############################################
data(AREDS)

results <- Select_link_BivCop(data = AREDS, cens1 = AREDS$cens1,
                              lowerBt1 = 't11', lowerBt2 = 't21',
                              upperBt1 = 't12', upperBt2 = 't22',
                              cens2 = AREDS$cens2, measure = 'AIC')
print(results)
}

}
