% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Birth}
\alias{Birth}
\title{Live birth rates in 1990 and 1998 for all states}
\format{
A data frame/tibble  with 51 observations on three variables
\describe{ 
\item{state}{a character with levels \code{Alabama},
\code{Alaska}, \code{Arizona}, \code{Arkansas}, \code{California},
\code{Colorado}, \code{Connecticut}, \code{Delaware}, \code{District of
Colunbia}, \code{Florida}, \code{Georgia}, \code{Hawaii}, \code{Idaho},
\code{Illinois}, \code{Indiana}, \code{Iowa}, \code{Kansas}, \code{Kentucky},
\code{Louisiana}, \code{Maine}, \code{Maryland}, \code{Massachusetts},
\code{Michigan}, \code{Minnesota}, \code{Mississippi}, \code{Missour},
\code{Montana}, \code{Nebraska}, \code{Nevada}, \code{New Hampshire}, \code{New
Jersey}, \code{New Mexico}, \code{New York}, \code{North Carolina}, \code{North
Dakota}, \code{Ohio}, \code{Oklahoma}, \code{Oregon}, \code{Pennsylvania},
\code{Rhode Island}, \code{South Carolina}, \code{South Dakota},
\code{Tennessee}, \code{Texas}, \code{Utah}, \code{Vermont}, \code{Virginia},
\code{Washington}, \code{West Virginia}, \code{Wisconsin}, and \code{Wyoming}}
\item{rate}{live birth rates per 1000 population} 
\item{year}{a factor with levels \code{1990} and \code{1998}} 
}
}
\source{
\emph{National Vital Statistics Report, 48}, March 28, 2000, National
Center for Health Statistics.
}
\usage{
Birth
}
\description{
Data for Example 1.10
}
\examples{

rate1998 <- subset(Birth, year == "1998", select = rate)
stem(x = rate1998$rate, scale = 2)
hist(rate1998$rate, breaks = seq(10.9, 21.9, 1.0), xlab = "1998 Birth Rate",
     main = "Figure 1.14 in BSDA", col = "pink")
hist(rate1998$rate, breaks = seq(10.9, 21.9, 1.0), xlab = "1998 Birth Rate",
     main = "Figure 1.16 in BSDA", col = "pink", freq = FALSE)      
lines(density(rate1998$rate), lwd = 3)
rm(rate1998)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
