% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_func.R
\name{get_adj_mat}
\alias{get_adj_mat}
\title{Adjacency matrix for counties of one or many states in the United States}
\usage{
get_adj_mat(county.adjacency,Countyvec,Statevec)
}
\arguments{
\item{county.adjacency}{data frame containing the neighborhood information for the counties of the entire US}

\item{Countyvec}{character vector containing the names of the counties for which the adjacency matrix is to be computed}

\item{Statevec}{character vector containing the names of the states the supplied counties belong to}
}
\value{
the corresponding adjacency matrix
}
\description{
Creates the adjacency matrix for the supplied counties within the United States using the available neighborhood information
}
\examples{
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))

}
