% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.pmf}
\alias{mcmc.pmf}
\title{Probability Mass Function for Pareto/GGG, Pareto/NBD (HB) and Pareto/NBD (Abe)}
\usage{
mcmc.pmf(draws, t, x, sample_size = 10000, covariates = NULL)
}
\arguments{
\item{draws}{MCMC draws as returned by \code{*.mcmc.DrawParameters}}

\item{t}{Length of time for which we are calculating the expected number of
transactions. May also be a vector.}

\item{x}{Number of transactions for which probability is calculated. May also
be a vector.}

\item{sample_size}{Sample size for estimating the probability distribution.}

\item{covariates}{(optional) Matrix of covariates, for Pareto/NBD (Abe)
model, passed to \code{\link{abe.GenerateData}} for simulating data.}
}
\value{
\eqn{P(X(t)=x)}. If either \code{t} or \code{x} is a vector, then the
  output will be a vector as well. If both are vectors, the output will be a
  matrix.
}
\description{
Return the probability distribution of purchase frequencies for a random
customer in a given time period, i.e. \eqn{P(X(t)=x)}. This is estimated by
generating \code{sample_size} number of random customers that follow the
provided parameter draws. Due to this sampling, the return result varies from
one call to another.
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
param.draws <- pnbd.mcmc.DrawParameters(cbs,
  mcmc = 100, burnin = 50, thin = 10, chains = 1) # short MCMC to run demo fast
mcmc.pmf(param.draws, t = c(26, 52), x = 0:6)
}
