% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barmorc.R
\name{calculate_mse}
\alias{calculate_mse}
\title{Calculates mean squared error}
\usage{
calculate_mse(step_ca, step_cb, dat_cacb, aa_Freq)
}
\arguments{
\item{step_ca}{Potential correction value for alpha carbon.}

\item{step_cb}{Potential correction value for beta carbon.}

\item{dat_cacb}{Chemical shift data frame of alpha and beta carbons.}

\item{aa_Freq}{Actual amino acid typing and secondary structure frequency calculated basing on provided protein sequence.}
}
\value{
Mean squared error.
}
\description{
This function will return a mean squared error between estimated density of amino acid typing and secondary structure combination based on the given dataset and reference correction values for the alpha and beta carbons. The estimated amino acid typing density is based on the BaMORC method.
}
\examples{
# chemicalShifts and aaFreq are predefined sample variables for demo purpose.

calculate_mse(step_ca=1, step_cb=1, dat_cacb=chemicalShifts[, c(3,4)], aa_Freq=aaFreq)

}
