% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tucker_model.R
\docType{class}
\name{Tucker_model}
\alias{Tucker_model}
\title{Factorization object for 3D Tucker models.}
\format{An \code{\link{R6Class}} generator object}
\usage{
Tucker_model
}
\description{
\code{Tucker_model} objects are 'R6' objects so that their values can be updated in place. 
The object is treated like an environment and components are accessed using the \code{$} 
operator. 
When creating a new Tucker_model object it will be populated with default values and empty matrices.
To initialize a \code{Tucker_model} call the \code{initialize()} method.
}
\section{Members}{

\describe{
  \item{iter}{Integer showing the number of iterations that have been run on this object.}
  \item{early.stop}{Stop if the lower bound increases by less than this value.}
  \item{lower.bnd}{Vector storing the lower bound values during training.}
  \item{RMSE}{Vector of the root mean squared error of the predictions during training.}
  \item{H.RMSE}{vector of the root mean squared error of predictions made by multiplying the H matrices.}
  \item{exp.var}{Vector of the explained variance of predictions during training.}
  \item{p.cor}{Vector of the Pearson correlation of predictions during training.}
  \item{s.cor}{Vector of the Spearman correlation of predictions during training.}
  \item{times}{Vector of the time taken for each update iteration.}
  \item{core.mean}{Mean parameters of the q Gaussian distributions in the core tensor.}
  \item{core.var}{Variance parameters of the q Gaussian distributions in the core tensor.}
  \item{core.lambda.shape}{Prior for the shape parameter of the gamma distribution on the core precision.}
  \item{core.lambda.scale}{Prior for the scale parameter of the gamma distribution on the core precision.}
  \item{resp}{array storing the predicted response tensor.}
  \item{delta}{binary array indicating whether the response is observed.}
  \item{core.var}{variance parameters of the q Gaussian distributions in the core tensor.}
  \item{m1Xm1X}{Product of mode1.X with itself stored to avoid recalculating.}
  \item{m2Xm2X}{Product of mode2.X with itself stored to avoid recalculating.}
  \item{m3Xm3X}{Product of mode3.X with itself stored to avoid recalculating.}
  \item{mode1.lambda.shape}{Matrix storing the shape parameters for the gamma distributions on the mode 1 projection (A) matrix.}
  \item{mode1.lambda.scale}{Matrix storing the scale parameters for the gamma distributions on the mode 1 projection (A) matrix.}
  \item{mode2.lambda.shape}{Matrix storing the shape parameters for the gamma distributions on the mode 2 projection (A) matrix.}
  \item{mode2.lambda.scale}{Matrix storing the scale parameters for the gamma distributions on the mode 2 projection (A) matrix.}
  \item{mode3.lambda.shape}{Matrix storing the shape parameters for the gamma distributions on the mode 3 projection (A) matrix.}
  \item{mode3.lambda.scale}{Matrix storing the scale parameters for the gamma distributions on the mode 3 projection (A) matrix.}
  \item{mode1.A.mean}{Matrix storing the mean parameters for the normal distributions on the mode 1 projection (A) matrix.}
  \item{mode1.A.cov}{Array storing the covariance parameters for the normal distributions on the mode 1 projection (A) matrix.}
  \item{mode2.A.mean}{Matrix storing the mean parameters for the normal distributions on the mode 2 projection (A) matrix.}
  \item{mode2.A.cov}{Array storing the covariance parameters for the normal distributions on the mode 2 projection (A) matrix.}
  \item{mode3.A.mean}{Matrix storing the mean parameters for the normal distributions on the mode 3 projection (A) matrix.}
  \item{mode3.A.cov}{Array storing the covariance parameters for the normal distributions on the mode 3 projection (A) matrix.}
  \item{mode1.H.mean}{Matrix storing the mean parameters for the normal distributions on the mode 1 latent (H) matrix.}
  \item{mode1.H.var}{Matrix storing the variance parameters for the normal distributions on the mode 1 latent (H) matrix.}
  \item{mode2.H.mean}{Matrix storing the mean parameters for the normal distributions on the mode 2 latent (H) matrix.}
  \item{mode2.H.var}{Matrix storing the variance parameters for the normal distributions on the mode 2 latent (H) matrix.}
  \item{mode3.H.mean}{Matrix storing the mean parameters for the normal distributions on the mode 3 latent (H) matrix.}
  \item{mode3.H.var}{Matrix storing the variance parameters for the normal distributions on the mode 3 latent (H) matrix.}
  \item{sigma2}{Variance for the response tensor.}
  \item{m1.sigma}{Variance for the mode 1 latent (H) matrix.}
  \item{m2.sigma}{Variance for the mode 2 latent (H) matrix.}
  \item{m3.sigma}{Variance for the mode 3 latent (H) matrix.}
  \item{m1.alpha}{Prior shape parameter for the gamma distribution on the precision of the mode 1 projection (A) matrix.}
  \item{m1.beta}{Prior scale paramet for the gamma distribution on the precision of the mode 1 projection (A) matrix.}
  \item{m2.alpha}{Prior shape parameter for the gamma distribution on the precision of the mode 2 projection (A) matrix.}
  \item{m2.beta}{Prior scale paramet for the gamma distribution on the precision of the mode 2 projection (A) matrix.}
  \item{m3.alpha}{Prior shape parameter for the gamma distribution on the precision of the mode 3 projection (A) matrix.}
  \item{m3.beta}{Prior scale paramet for the gamma distribution on the precision of the mode 3 projection (A) matrix.}
  \item{core.alpha}{Prior shape parameter for the gamma distribution on the precision of the core tensor.}
  \item{core.beta}{Prior scale parameter for the gamma distribution on the precision of the core tensor.}
  \item{core.0D.alpha}{Prior shape parameter for the gamma distribution on the precision of the 0D subset of the core tensor.}
  \item{core.0D.beta}{Prior scale parameter for the gamma distribution on the precision of the 0D subset of the core tensor.}
  \item{core.1D.alpha}{Prior shape parameter for the gamma distribution on the precision of the 1D subset of the core tensor.}
  \item{core.1D.beta}{Prior scale parameter for the gamma distribution on the precision of the 1D subset of the core tensor.}
  \item{core.2D.alpha}{Prior shape parameter for the gamma distribution on the precision of the 2D subset of the core tensor.}
  \item{core.2D.beta}{Prior scale parameter for the gamma distribution on the precision of the 2D subset of the core tensor.}
  \item{core.3D.alpha}{Prior shape parameter for the gamma distribution on the precision of the 3D subset of the core tensor.}
  \item{core.3D.beta}{Prior scale parameter for the gamma distribution on the precision of the 3D subset of the core tensor.}
}
}

\section{Methods}{

\describe{
  \item{\code{new(data, params)}}{Creates a new \code{Tucker_model} object with
  matrices sized accoring to the matrices in \code{data}.}
  \item{\code{rand_init(params)}}{Initializes the \code{Tucker_model} with
  random values accoring to \code{params}.}
}
}
\examples{
data.params <- get_data_params(c('decomp=Tucker'))
toy <- mk_toy(data.params)
train.data <- input_data$new(mode1.X=toy$mode1.X[,-1],
                             mode2.X=toy$mode2.X[,-1],
                             mode3.X=toy$mode3.X[,-1],
                             resp=toy$resp)
model.params <- get_model_params(c('decomp=Tucker'))
toy.model <- mk_model(train.data, model.params)
toy.model$rand_init(model.params)
}
\keyword{datasets}

