% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{evalArena}
\alias{evalArena}
\alias{evalArena,Eval-method}
\title{Function for plotting spatial and temporal change of populations and/or concentrations}
\usage{
evalArena(object, plot_items = "Population", phencol = F, retdata = F,
  time = (seq_along(object@simlist) - 1))

\S4method{evalArena}{Eval}(object, plot_items = "Population", phencol = F,
  retdata = F, time = (seq_along(object@simlist) - 1))
}
\arguments{
\item{object}{An object of class Eval.}

\item{plot_items}{A character vector giving the items, which should be plotted.}

\item{phencol}{A boolean variable indicating if the phenotypes of the organisms in the environment should be integrated as different colors in the population plot.}

\item{retdata}{A boolean variable indicating if the data used to generate the plots should be returned.}

\item{time}{A numeric vector giving the simulation steps which should be plotted.}
}
\value{
Returns several plots of the chosen plot items. Optional the data to generate the original plots can be returned.
}
\description{
The generic function \code{evalArena} plots heatmaps from the simulation steps in an \code{Eval} object.
}
\details{
If \code{phencol} is \code{TRUE} then different phenotypes of the same organism are visualized by varying colors, otherwise different organism types are represented by varying colors. The parameter \code{retdata} can be used to access the data used for the returned plots to create own custom plots.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,10)
evalArena(eval)
\dontrun{
## if animation package is installed a movie of the simulation can be stored:
library(animation)
saveVideo({evalArena(eval)},video.name="Ecoli_sim.mp4")
}
}
\seealso{
\code{\link{Eval-class}} and \code{\link{Arena-class}}
}

