% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{plotCurves}
\alias{plotCurves}
\alias{plotCurves,Eval-method}
\title{Function for plotting the overall change as curves}
\usage{
plotCurves(object, medplot = object@mediac, retdata = F, remove = F,
  legend = F)

\S4method{plotCurves}{Eval}(object, medplot = object@mediac, retdata = F,
  remove = F, legend = F)
}
\arguments{
\item{object}{An object of class Eval.}

\item{medplot}{A character vector giving the name of substances which should be plotted.}

\item{retdata}{A boolean variable indicating if the data used to generate the plots should be returned.}

\item{remove}{A boolean variable indicating if substances, which don't change in their concentration should be removed from the plot.}

\item{legend}{Boolean variable indicating if legend should be plotted}
}
\value{
Returns two graphs in one plot: the growth curves and the curves of concentration changes. Optional the data to generate the original plots can be returned.
}
\description{
The generic function \code{plotCurves} plots the growth curves and concentration changes of substances from simulation steps in an \code{Eval} object.
}
\details{
The parameter \code{retdata} can be used to access the data used for the returned plots to create own custom plots.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,10)
plotCurves(eval)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{Arena-class}}
}

