% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\name{dat2mat}
\alias{dat2mat}
\alias{dat2mat,Arena-method}
\title{Function for transforming the organism data frame to a presence/absence matrix of organisms}
\usage{
dat2mat(object)

\S4method{dat2mat}{Arena}(object)
}
\arguments{
\item{object}{An object of class Arena.}
}
\value{
Returns the presence/absence matrix of organisms on the grid based on the \code{orgdat} slot of the \code{Arena} class.
}
\description{
The generic function \code{dat2mat} simulates the event of mixing all substrates and organisms in the environment.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
occmat <- dat2mat(arena)
image(occmat)
}
\seealso{
\code{\link{Arena-class}} and \code{\link{getSublb}}
}
