% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.inequality.R
\name{plot.inequality}
\alias{plot.inequality}
\title{Plot Lorenz curve from a 'inequality' object}
\usage{
\method{plot}{inequality}(x, title = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{inequality}.}

\item{title}{character, plot title.}

\item{...}{other graphical parameters.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot Lorenz curve from a 'inequality' object
}
\examples{
Pbox.BN <- subset(Pbox, Team=="Brooklyn Nets")
out <- inequality(Pbox.BN$PTS, nplayers=8)
print(out)
plot(out)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{inequality}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
