% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.raw.data.R
\name{plot.onemap}
\alias{plot.onemap}
\title{Draw a graphic of raw data for any OneMap population}
\usage{
\method{plot}{onemap}(x, all = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{onemap}, with data and additional information}

\item{all}{a TRUE/FALSE option to indicate if results will be
plotted together (if TRUE) or splitted based on their
segregation pattern. Only used for outcross populations.}

\item{...}{currently ignored}
}
\value{
a ggplot graphic
}
\description{
Shows a heatmap (in ggplot2, a graphic of geom "tile") for raw data.
Lines correspond to markers and columns to individuals.
The function can plot a graph for all marker types, depending of the cross type (dominant/codominant markers, in all combinations).
The function receives a onemap object of class \code{onemap}, reads information
from genotypes from this object, converts it to a long dataframe format
using function melt() from package reshape2() or internal function create.dataframe.for.plot.outcross(), converts numbers from the object
to genetic notation (according to the cross type), then plots the graphic.
If there is more than 20 markers, removes y labels
For outcross populations, it can show all markers together, or it can split them according the segregation
pattern.
}
\examples{
data(example.out) # Loads a fake full-sib dataset installed with onemap
plot(example.out) # This will show you the graph for all markers
plot(example.out, all=FALSE) # This will show you the graph splitted for marker types

# You can store the graphic in an object, then save it.
# For details, see the help of ggplot2's function ggsave()
g <- plot(example.out, all=FALSE)
ggsave("MyRawData_out.jpg", g, width=9, height=4, dpi=600)

}
