\name{CPPevalHR}
\alias{CPPevalHR}
\title{Function to Evaluate CPP Hazard Rates}
\description{A function to evaluate a (prior or posterior) sample of CPP hazard rates on a grid of time points.}
\usage{CPPevalHR(time, sample)}
\arguments{
  \item{time}{vector of time points where the hazard rates in the sample should be evaluated}
  \item{sample}{sample of CPP hazard rates (as generated by \code{\link{CPPpriorSample}} or \code{\link{CPPpostSample}})}
}
\value{A matrix with as many rows as hazard rates in the sample and as many columns as time points in the grid.}
\seealso{\code{\link{CPPplotHR}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a CPP prior distribution
hypars<-CPPpriorElicit(r0 = 0.1, H = 1, T00 = 50, M00 = 2)
# generate a sample of ten hazard rates
prior<-CPPpriorSample(ss = 10, hyp = hypars)

# evaluate the ten hazard rates at year multiples
CPPevalHR(time = seq(0,50), sample = prior)

# load a data set
data(earthquakes)
# generate a posterior sample
post<-CPPpostSample(hypars, times = earthquakes$ti, obs = earthquakes$ob)

# evaluate the posterior hazard rates at year multiples
CPPevalHR(time = seq(0,50), sample = post)
}
\keyword{survival}
