% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Ages.R
\name{plot_Ages}
\alias{plot_Ages}
\title{Create Age Plot}
\usage{
plot_Ages(object, sample_names = NULL, sample_order = NULL, ...)
}
\arguments{
\item{object}{\link{list}  or \link{data.frame} (\strong{required}): Output as created by functions like \link{AgeC14_Computation}, which
is a list of class \code{BayLum.list}. Alternativley the function supports a \link{data.frame} as input, however,
in such a case the \link{data.frame} must resemble the ages \link{data.frame} created by the computation functions
otherwise the input will be silently ignored.}

\item{sample_names}{\link{character} (optional): alternative sample names used for the plotting.
If the length of the provided \link{character} vector is shorter than the real number of samples, the names are recycled.}

\item{sample_order}{\link{numeric} (optional): argument to rearrange the sample order, e.g., \code{sample_order = c(4:1)} plots
the last sample first.}

\item{...}{further arguments to control the plot output,
standard arguments are: \code{cex}, \code{xlim}, \code{main}, \code{xlab}, \code{col} further (non-standard) arguments
are: \code{grid} (\code{TRUE}/\code{FALSE}), \code{legend} (\code{TRUE}/\code{FALSE}), \code{legend.text} (\link{character} input needed), \code{legend.pos} \link[graphics:legend]{graphics::legend}}
}
\value{
The function returns a plot and the \link{data.frame} used to display the data
}
\description{
Create Age Plot
}
\details{
This function creates an age plot showing the mean ages along with the credible intervals. The function
provides various arguments to modify the plot output, however, for an ultimate control the function returns
the \link{data.frame} extracted from the input object for own plots.
}
\section{Function version}{
 0.1.4
}

\examples{
## load data
data(DATA_C14,envir = environment())
C14Cal <- DATA_C14$C14[,1]
SigmaC14Cal <- DATA_C14$C14[,2]
Names <- DATA_C14$Names
nb_sample <- length(Names)

## Age computation
Age <- AgeC14_Computation(
   Data_C14Cal = C14Cal,
   Data_SigmaC14Cal = SigmaC14Cal,
   SampleNames = Names,
   Nb_sample = nb_sample,
   PriorAge = rep(c(20,60),nb_sample),
   Iter = 500,
   quiet = TRUE)

## plot output
plot_Ages(Age)

}
\seealso{
\link{AgeC14_Computation}, \link{AgeS_Computation}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, UMR 5060, CNRS-Université Bordeaux Montaigne (France), based on code
written by Claire Christophe
} 

\section{How to cite}{
Kreutzer, S., Christophe, C., 2020. plot_Ages(): Create Age Plot. Function version 0.1.4. In: Christophe, C., Philippe, A., Kreutzer, S., Guerin, G., 2020. BayLum: Chronological Bayesian Models Integrating Optically Stimulated. R package version 0.2.0. https://CRAN.r-project.org/package=BayLum
}

