% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{clust_cp_uni}
\alias{clust_cp_uni}
\title{Clustering univariate times series with common changes in time}
\usage{
clust_cp_uni(
  data,
  n_iterations,
  B,
  L,
  gamma,
  a = 1,
  b = 1,
  c = 1,
  q = 0.5,
  alpha_SM = 0.1,
  print_progress = TRUE,
  user_seed = 1234L
)
}
\arguments{
\item{data}{a matrix where each row is an observation and each column corresponds to a discrete time.}

\item{n_iterations}{number of MCMC iterations.}

\item{B}{number of orders for the normalisation constant.}

\item{L}{number of split-merge steps for the proposal step.}

\item{gamma, a, b, c}{parameters \eqn{\gamma} of the integrated likelihood.}

\item{q}{probability of a split in the split-merge proposal and acceleration step.}

\item{alpha_SM}{\eqn{\alpha} for the split-merge proposal and acceleration step.}

\item{print_progress}{If TRUE (default) print the progress bar.}

\item{user_seed}{seed for random distribution generation.}
}
\value{
Function \code{clust_cp_uni} returns a list containing the following components: \itemize{
\item{\code{$clust}} a matrix where each row corresponds to the output cluster of the corresponding iteration.
\item{\code{$orders}} a multidimensional array where each slice is a matrix and represent an iteration. The row of each matrix correspond the order associated to the corresponding cluster.
\item{\code{$time}} computational time in seconds.
\item{\code{$norm_vec}} a vector containing the normalisation constant computed at the beginning of the algorithm.
}
}
\description{
Clustering univariate times series with common changes in time
}
\examples{
\donttest{
data_mat <- matrix(NA, nrow = 5, ncol = 100)

data_mat[1,] <- as.numeric(c(rnorm(50,0,0.100), rnorm(50,1,0.250)))
data_mat[2,] <- as.numeric(c(rnorm(50,0,0.125), rnorm(50,1,0.225)))
data_mat[3,] <- as.numeric(c(rnorm(50,0,0.175), rnorm(50,1,0.280)))
data_mat[4,] <- as.numeric(c(rnorm(25,0,0.135), rnorm(75,1,0.225)))
data_mat[5,] <- as.numeric(c(rnorm(25,0,0.155), rnorm(75,1,0.280)))

out <- clust_cp_uni(data = data_mat, n_iterations = 5000, B = 1000, L = 1, gamma = 0.5)
}
}
