% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtcnorm.R
\name{RTCNormal}
\alias{RTCNormal}
\alias{drtcnorm}
\alias{rtcnorm}
\alias{prtcnorm}
\title{The Restricted Two-Component Normal Distribution}
\usage{
drtcnorm(x, p, mu, sig1, sig2, log = FALSE)

prtcnorm(q, p, mu, sig1, sig2, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x}{A vector of quantiles.}

\item{p}{A scalar mixture weight.}

\item{mu}{A scalar separation parameter.}

\item{sig1}{A scalar standard deviation for the first component.}

\item{sig2}{A scalar standard deviation for the second component.}

\item{log}{A logical value indication whether a probability \code{p}.}

\item{lower.tail}{A logical value indicated whether or not to take the
cumulative distribution function with respect to the lower tail
(alternatively upper).}
}
\value{
\code{drtcnorm} gives the density, \code{prtcnorm} gives the distribution.
The length of the result is determined by the length of \code{x} for \code{drtcnorm}.
}
\description{
Density and distribution functions for the mean-restricted
two-component normal distribution.
}
\keyword{internal}
