% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f2bayes.R
\name{f2bayes}
\alias{f2bayes}
\title{Calculation of a Bayesian 100*prob\% credible interval for the F2 parameter}
\usage{
f2bayes(
  dis_data,
  prob = 0.9,
  B = 1000,
  ci.type = c("quantile", "HPD"),
  get.dist = FALSE
)
}
\arguments{
\item{dis_data}{A data frame containing the dissolution data. The first column of the data frame should denote
the group labels identifying whether a given dissolution belongs to the "reference" or "test" formulation group.
For a given dissolution run, the remaining columns of the data frame contains the individual run's dissolution
measurements sorted in time. Alternatively, the user may provide a data object of class dis_data containing the
dissolution data. See the \code{make_dis_data()} function for the particular structure of the data object.}

\item{prob}{The probability associated with the credible interval. A value between 0 and 1.}

\item{B}{A positive integer specifying the number of Monte Carlo samples.}

\item{ci.type}{The type of credible interval to report. Specifying \code{quantile} returns a credible interval based on the posterior sample quantiles of the F2 distribution. Specifying \code{HPD} returns a highest posterior density interval.}

\item{get.dist}{logical; if \code{TRUE}, returns the posterior samples of the F2 distribution.}
}
\value{
The function returns a 100*prob\% credible interval for the F2 parameter calculated from the observed dissolution data.
}
\description{
This function calculates a 100*prob\% credible interval for the F2 parameter using Bayesian methods. The model assumes a
version of the Jerffreys' prior with a pooled variance-covariance matrix from based on the reference and test data sets.
See Novick (2015) for more details of the model.
}
\note{
Use the \code{plotdiss()} or \code{ggplotdiss()} function to visually check if it's appropriate to calculate the f2 statistic.
}
\examples{
### dis_data comes loaded with the package
f2bayes(dis_data, prob = 0.9, B = 1000)

}
\references{
Novick, S., Shen, Y., Yang, H., Peterson, J., LeBlond, D., and Altan, S. (2015). Dissolution Curve Comparisons Through the F2 Parameter, a Bayesian Extension of the f2 Statistic. Journal of Biopharmaceutical Statistics, 25(2):351-371.

Pourmohamad, T., Oliva Aviles, C.M., and Richardson, R. Gaussian Process Modeling for Dissolution Curve Comparisons. Journal of the Royal Statistical Society, Series C, 71(2):331-351.
}
