% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{sampler.SGLD}
\alias{sampler.SGLD}
\title{Stochastic Gradient Langevin Dynamics as proposed in Welling, M., & Teh, Y. W.
(n.d.). Bayesian Learning via Stochastic Gradient Langevin Dynamics. 8.}
\usage{
sampler.SGLD(
  stepsize_a = 0.1,
  stepsize_b = 0,
  stepsize_gamma = 0.55,
  min_stepsize = -Inf
)
}
\arguments{
\item{stepsize_a}{See eq. above}

\item{stepsize_b}{See eq. above}

\item{stepsize_gamma}{see eq. above}

\item{min_stepsize}{Do not decrease stepsize beyond this}
}
\value{
a list with `juliavar`, `juliacode`, and all given arguments
}
\description{
Stepsizes will be adapted according to
\deqn{a(b+t)^{-\gamma}}
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sampler <- sampler.SGLD()
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
