% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_freq_distr.R
\name{rank_freq_distr}
\alias{rank_freq_distr}
\title{Frequency distribution of the ranking sequences}
\usage{
rank_freq_distr(rankings)
}
\arguments{
\item{rankings}{A matrix with the individual rankings in each row.}
}
\value{
Numeric matrix with the distinct rankings in each row and the
  corresponding frequencies indicated in the last \code{(n_items+1)}-th
  column.
}
\description{
Construct the frequency distribution of the distinct ranking
  sequences from the dataset of the individual rankings. This can be of
  interest in itself, but also used to speed up computation by providing
  the \code{obs_freq} argument to \code{\link{compute_mallows}}.
}
\examples{
# Create example data. We set the burn-in and thinning very low
# for the sampling to go fast
data0 <- sample_mallows(rho0 = 1:5, alpha = 10, n_samples = 1000,
                        burnin = 10, thinning = 1)
# Find the frequency distribution
rank_freq_distr(rankings = data0)
}
\seealso{
Other rank functions: 
\code{\link{expected_dist}()},
\code{\link{get_mallows_loglik}()},
\code{\link{rank_conversion}},
\code{\link{rank_distance}()},
\code{\link{sample_mallows}()}
}
\concept{rank functions}
