% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcTab.R
\name{mcmcTab}
\alias{mcmcTab}
\title{Summarize Bayesian MCMC Output
 
R function for summarizing MCMC output in a regression-style table.}
\usage{
mcmcTab(sims, ci = c(0.025, 0.975), pars = NULL, Pr = FALSE,
  ROPE = NULL, regex = FALSE)
}
\arguments{
\item{sims}{Bayesian model object generated by R2jags, rjags, R2WinBUGS, 
R2OpenBUGS, MCMCpack, rstan, and rstanarm.}

\item{ci}{desired level for credible intervals; defaults to c(0.025, 0.975).}

\item{pars}{character vector of parameters to be printed; defaults to \code{NULL} 
(all parameters are printed). If not \code{NULL}, the user can either specify the exact names of 
parameters to be printed (e.g. \code{c("alpha", "beta1", "beta2")}) or part of a name 
so that all parameters containing that name will be printed (e.g. \code{"beta"} will print \code{beta1}, \code{beta2}, etc.).}

\item{Pr}{print percent of posterior draws with same sign as median; defaults to \code{FALSE}.}

\item{ROPE}{defaults to \code{NULL}. If not \code{NULL}, a vector of two values defining the region of 
practical equivalence ("ROPE"); returns \% of posterior draws to the left/right of ROPE. For this quantity 
to be meaningful, all parameters must be on the same scale (e.g. standardized coefficients 
or first differences). See Kruschke (2013, Journal of Experimental 
Psychology 143(2): 573-603) for more on the ROPE.}

\item{regex}{use regular expression matching with \code{pars}?}
}
\value{
a data frame containing MCMC summary statistics.
}
\description{
Summarize Bayesian MCMC Output
 
R function for summarizing MCMC output in a regression-style table.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
\donttest{
data("jags_logit")

## printing out table
object <- mcmcTab(jags_logit, 
          ci = c(0.025, 0.975), 
          pars = NULL, 
          Pr = FALSE,
          ROPE = NULL)
object
}

\dontshow{setwd(.old_wd)}
}
\references{
Kruschke, John K. 2013. “Bayesian Estimation Supersedes the T-Test.” Journal of 
  Experimental Psychology: General 142 (2): 573–603. https://doi.org/10.1037/a0029146.
}
