% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBvs.R
\name{plot.Bvs}
\alias{plot.Bvs}
\title{A function for plotting summaries of an object of class \code{Bvs}}
\usage{
\method{plot}{Bvs}(x, option = "dimension", ...)
}
\arguments{
\item{x}{An object of class \code{Bvs}}

\item{option}{One of "dimension", "joint", "conditional" or "not"}

\item{...}{Additional graphical parameters to be passed}
}
\value{
If \code{option}="joint", "conditional" or "not" \code{plot} also
returns an object of class \code{matrix} with the numeric values of the
printed probabilities.
}
\description{
Four different plots to summarize graphically the results in an object of
class \code{Bvs}.
}
\details{
If \code{option}="dimension" this function returns a barplot of the
posterior distribution of the dimension of the true model. If
\code{option}="joint" an image plot of the joint inclusion probabilities is
returned. If \code{option}="conditional" an image plot of the conditional
inclusion probabilities. These should be read as the probabilty that the
variable in the column is part of the true model if the corresponding
variables on the row is. If \code{option}="not" the image plot that
is returned is that of the the probabilty that the variable in the column is
part of the true model if the corresponding variables on the row is not. Finally,
if \code{option}="trace", only available if x$method == "Gibbs", returns a plot of the trace of the inclusion probabilities to check for convergence.
}
\examples{


#Analysis of Crime Data
#load data
data(UScrime)

#Default arguments are Robust prior for the regression parameters
#and constant prior over the model space
#Here we keep the 1000 most probable models a posteriori:
crime.Bvs<- Bvs(formula= y ~ ., data=UScrime, n.keep=1000)

#A look at the results:
crime.Bvs

summary(crime.Bvs)

#A plot with the posterior probabilities of the dimension of the
#true model:
plot(crime.Bvs, option="dimension")

#An image plot of the joint inclusion probabilities:
plot(crime.Bvs, option="joint")

#Two image plots of the conditional inclusion probabilities:
plot(crime.Bvs, option="conditional")
plot(crime.Bvs, option="not")


}
\seealso{
See \code{\link[BayesVarSel]{Bvs}}, \code{\link[BayesVarSel]{GibbsBvs}} for creating objects of the class
\code{Bvs}.
}
\author{
Gonzalo Garcia-Donato and Anabel Forte

Maintainer: <anabel.forte@uv.es>
}
