% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesGLM2.R
\name{BayesGLM2}
\alias{BayesGLM2}
\alias{BayesGLM_group}
\title{Group-level Bayesian GLM}
\usage{
BayesGLM2(
  results,
  contrasts = NULL,
  quantiles = NULL,
  excursion_type = NULL,
  contrast_names = NULL,
  gamma = 0,
  alpha = 0.05,
  nsamp_theta = 50,
  nsamp_beta = 100,
  num_cores = NULL,
  verbose = 1
)

BayesGLM_group(
  results,
  contrasts = NULL,
  quantiles = NULL,
  excursion_type = NULL,
  gamma = 0,
  alpha = 0.05,
  nsamp_theta = 50,
  nsamp_beta = 100,
  num_cores = NULL,
  verbose = 1
)
}
\arguments{
\item{results}{Either (1) a length \eqn{N} list of \code{"BayesGLM"} objects,
or (2) a length \eqn{N} character vector of files storing \code{"BayesGLM"}
objects saved with \code{\link{saveRDS}}.}

\item{contrasts}{(Optional) A list of contrast vectors that specify the
group-level summaries of interest. If \code{NULL}, use contrasts that compute
the average of each field (task HRF) across subjects and sessions.

Each contrast vector is length \eqn{K * S * N} vector specifying a
group-level summary of interest, where \eqn{K} is the number
of fields (task HRFs), \eqn{S} is the number of sessions, and \eqn{N} is the
number of subjects. For a single subject-session the contrast
for the first field would be:

\code{contrast1 <- c(1, rep(0, K-1))}

and so the full contrast vector representing the group average across
sessions and subjects for the first task would be:

\code{rep(rep(contrast1, S), N) /S /N}.

To obtain the group average for the first task, for just the first sessions
from each subject:

\code{rep(c(contrast1, rep(0, K*(S-1))), N) /N}.

To obtain the mean difference between the first and second sessions, for the
first task:

\code{rep(c(contrast1, -contrast1, rep(0, K-2)), N) /N}.

To obtain the mean across sessions of the first task, just for the first
subject:

\code{c(rep(contrast1, S-1), rep(0, K*S*(N-1)) /S}.}

\item{quantiles}{(Optional) Vector of posterior quantiles to return in
addition to the posterior mean.}

\item{excursion_type}{(For inference only) The type of excursion function for
the contrast (">", "<", "!="), or a vector thereof (each element
corresponding to one contrast).  If \code{NULL}, no inference performed.}

\item{contrast_names}{(Optional) Names of contrasts.}

\item{gamma}{(For inference only) Activation threshold for the excursion set,
or a vector thereof (each element corresponding to one contrast). Default:
\code{0}.}

\item{alpha}{(For inference only) Significance level for activation for the
excursion set, or a vector thereof (each element corresponding to one
contrast). Default: \code{.05}.}

\item{nsamp_theta}{Number of theta values to sample from posterior. Default:
\code{50}.}

\item{nsamp_beta}{Number of beta vectors to sample conditional on each theta
value sampled. Default: \code{100}.}

\item{num_cores}{The number of cores to use for sampling betas in parallel. If
\code{NULL} (default), do not run in parallel.}

\item{verbose}{Should updates be printed? Use \code{1} (default) for
occasional updates, \code{2} for occasional updates as well as running INLA
in verbose mode (if applicable), or \code{0} for no updates.}
}
\value{
A list containing the estimates, PPMs and areas of activation for each contrast.
}
\description{
Performs group-level Bayesian GLM estimation and inference using the joint
approach described in Mejia et al. (2020).
}
\section{INLA Requirement}{

This function requires the \code{INLA} package, which is not a CRAN package.
See \url{https://www.r-inla.org/download-install} for easy installation instructions.
}

