% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_logical_0.R
\name{is_na_in_vector}
\alias{is_na_in_vector}
\title{Detect NA in a vector}
\usage{
is_na_in_vector(vect)
}
\arguments{
\item{vect}{A vector, whose components are allowed to be numeric, character, etc.}
}
\value{
A logical. If \code{vect} contains at least one \code{NA}, then \code{TRUE}. Otherwise \code{FALSE}.
}
\description{
Detect NA in a vector
}
\examples{

 is_na_in_vector(  c(NA,1)      )

 is_na_in_vector(  c(6,1)      )

 is_na_in_vector(  c(1:5,NA,1)      )

 is_na_in_vector(  c(1:5,1)      )

 is_na_in_vector(  c(1:5,NA,1,NA)      )

 is_na_in_vector(  c(1:51,"asdfg")      )

 is_na_in_vector(  c(1:5,NA,1,NA,"asdfg")      )

}
