% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Simulation_AdaptiveRandomisationmethodRatioCalc.R
\name{ARmethod}
\alias{ARmethod}
\title{ARmethod}
\usage{
ARmethod(
  Fixratio,
  BARmethod,
  group,
  stats,
  post.prob.btcontrol,
  K,
  n,
  tuningparameter = NA,
  c = NA,
  a = NA,
  b = NA,
  post.prob.best,
  max.ar = NA,
  armleft,
  treatmentindex
)
}
\arguments{
\item{Fixratio}{A indicator TRUE/FALSE}

\item{BARmethod}{The indicator of which adaptive randomisation method is used}

\item{group}{The current stage}

\item{stats}{The output matrix}

\item{post.prob.btcontrol}{The vector of posterior probability of each active treatment arm better than control}

\item{K}{Total number of arms at the beginning}

\item{n}{The vector of sample size for each arm}

\item{tuningparameter}{The tuning parameter indicator for Thall's approach}

\item{c}{The tuning parameter for Thall's approach}

\item{a}{The hyperparamter parameter for Trippa's approach}

\item{b}{The hyperparamter parameter for Trippa's approach}

\item{post.prob.best}{Posterior probability of each arm to be the best}

\item{max.ar}{The upper boundary for randomisation ratio for each arm, which is used in Thall's approach since Trippa's approach has protection on control arm.}

\item{armleft}{The number of treatment left in the platform (>2)}

\item{treatmentindex}{The vector of treatment arm index excluding the control arm whose index is 0}
}
\value{
randomprob: The vector of adjusted randomisation probability to each arm
}
\description{
This function adjusts the posterior randomisation probability for each arm using many approaches.
Currently Thall's approach and Trippa's approach are used.
Double biased coin and other method will be added in the next version.
}
\examples{
ARmethod(Fixratio = FALSE,
BARmethod = "Thall",
group = 1,
stats = matrix(rep(NA, 40), ncol = 8, nrow = 5),
post.prob.btcontrol = 0.5,
K = 2,
n = c(30, 30),
tuningparameter = "fixed",
c = 1,
post.prob.best = c(0.5, 0.5),
max.ar = 0.75,
armleft = 2,
treatmentindex = 1)

ARmethod(Fixratio = FALSE,
BARmethod = "Trippa",
group = 1,
stats = matrix(rep(NA, 40), ncol = 8, nrow = 5),
post.prob.btcontrol = c(0.5, 0.6),
K = 3,
n = c(30, 30, 40),
tuningparameter = NA,
c = NA,
a = 3,
b = 0.75,
post.prob.best = c(0.3, 0.3, 0.4),
max.ar = NA,
armleft = 3,
treatmentindex = c(1, 2))

}
\references{
Bayesian adaptive randomized trial design for patients with recurrent glioblastoma. Trippa, Lorenzo, Eudocia Q. Lee, Patrick Y. Wen, Tracy T. Batchelor, Timothy Cloughesy, Giovanni Parmigiani, and Brian M. Alexander. Journal of Clinical Oncology 30, no. 26 (2012): 3258.
A simulation study of outcome adaptive randomization in multi-arm clinical trials. Wathen, J. Kyle, and Peter F. Thall. Clinical Trials 14, no. 5 (2017): 432-440.
}
\author{
Ziyan Wang
}
