% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcTwalk.R
\name{Twalk}
\alias{Twalk}
\title{T-walk MCMC}
\usage{
Twalk(bayesianSetup, settings = list(iterations = 10000, at = 6, aw = 1.5, pn1
  = NULL, Ptrav = 0.4918, Pwalk = 0.4918, Pblow = 0.0082, burnin = 0, thin = 1,
  startValue = NULL, consoleUpdates = 100, message = TRUE))
}
\arguments{
\item{bayesianSetup}{Object of class 'bayesianSetup' or 'bayesianOuput'.}

\item{settings}{list with parameter values.}

\item{iterations}{Number of model evaluations}

\item{at}{"traverse" move proposal parameter. Default to 6}

\item{aw}{"walk" move proposal parameter. Default to 1.5}

\item{pn1}{Probability determining the number of parameters that are changed}

\item{Ptrav}{Move probability of "traverse" moves, default to 0.4918}

\item{Pwalk}{Move probability of "walk" moves, default to 0.4918}

\item{Pblow}{Move probability of "traverse" moves, default to 0.0082}

\item{burnin}{number of iterations treated as burn-in. These iterations are not recorded in the chain.}

\item{thin}{thinning parameter. Determines the interval in which values are recorded.}

\item{startValue}{Matrix with start values}

\item{consoleUpdates}{Intervall in which the sampling progress is printed to the console}

\item{message}{logical determines whether the sampler's progress should be printed}
}
\value{
Object of class bayesianOutput.
}
\description{
T-walk MCMC
}
\details{
The probability of "hop" moves is 1 minus the sum of all other probabilities.
}
\references{
Christen, J. Andres, and Colin Fox. "A general purpose sampling algorithm for continuous distributions (the t-walk)." Bayesian Analysis 5.2 (2010): 263-281.
}
