% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes_singletest_rel.R
\name{strel}
\alias{strel}
\title{calculate single test reliability estimates}
\usage{
strel(
  x,
  estimates = c("alpha", "lambda2", "glb", "omega"),
  interval = 0.95,
  n.iter = 1000,
  n.burnin = 50,
  n.boot = 1000,
  omega.freq.method = "cfa",
  n.obs = NULL,
  alpha.int.analytic = FALSE,
  freq = TRUE,
  Bayes = TRUE,
  para.boot = FALSE,
  item.dropped = FALSE,
  missing = "listwise"
)
}
\arguments{
\item{x}{A dataset or covariance matrix}

\item{estimates}{A character vector containing the estimands, we recommend using lambda4 with only a few items due to the computation time}

\item{interval}{A number specifying the uncertainty interval}

\item{n.iter}{A number for the iterations of the Gibbs Sampler}

\item{n.burnin}{A number for the burnin in the Gibbs Sampler}

\item{n.boot}{A number for the bootstrap samples}

\item{omega.freq.method}{A character string for the method of frequentist omega, either "pfa" or "cfa"}

\item{n.obs}{A number for the sample observations when a covariance matrix is supplied and the factor model is calculated}

\item{alpha.int.analytic}{A logical for calculating the alpha confidence interval analytically}

\item{freq}{A logical for calculating the frequentist estimates}

\item{Bayes}{A logical for calculating the Bayesian estimates}

\item{para.boot}{A logical for calculating the parametric bootstrap, the default is the non-parametric}

\item{item.dropped}{A logical for calculating the if-item-dropped statistics}

\item{missing}{A string specifying the way to handle missing data}
}
\description{
calculate Bayesian and frequentist single test reliability measures.
Reported are Bayesian credible intervals (HDI) and frequentist confidence intervals (non parametric or parametric bootstrap).
The estimates supported are Cronbach alpha, lambda2/4/6, the glb, and Mcdonald omega. Beware of lambda4 with many indicators,
the computational effort is considerable
}
\examples{
summary(strel(asrm, estimates = "lambda2"))
summary(strel(asrm, estimates = "lambda2", item.dropped = TRUE))


}
\references{
{
  \insertRef{murphy2007}{Bayesrel}
  \insertRef{lee2007}{Bayesrel}
}
}
