% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.BchronologyRun.R
\name{summary.BchronologyRun}
\alias{summary.BchronologyRun}
\title{Summarise a Bchronology object}
\usage{
\method{summary}{BchronologyRun}(object, type = c("quantiles", "outliers",
  "convergence", "sed_rate", "acc_rate"), probs = c(0.025, 0.1, 0.5, 0.9,
  0.975), useExisting = TRUE, ..., digits = max(3, getOption("digits") - 3))
}
\arguments{
\item{object}{Output from a run of \code{\link{Bchronology}}}

\item{type}{Type of output required. The default (quantiles) gives the quantiles of the ages for each position in \code{predictPositions} from \code{\link{Bchronology}}. The other options provide outlier probabilities, convergence diagnostics, accumulation rates and sedimentation rate}

\item{probs}{Probabilities (between 0 and 1) at which to summarise the predicted chronologies}

\item{useExisting}{Whether to use the predicted chronologies/positions to calculate the sedimentation rate (if TRUE - default) or to re-create them based on a unit-scaled position grid (if FALSE). The latter will be a little bit slower but will provide better sedimentation rate estimates if the original positions are not on a unit scale (e.g. each cm)}

\item{...}{Other arguments (not currently supported)}

\item{digits}{Number of digits to report values}
}
\description{
Summarise a \code{\link{Bchronology}} object
}
\seealso{
\code{\link{BchronCalibrate}}, \code{\link{Bchronology}} \code{\link{BchronRSL}}, \code{\link{BchronDensity}}, \code{\link{BchronDensityFast}}
}

