% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unCalibrate.R
\name{unCalibrate}
\alias{unCalibrate}
\title{Uncalibrate a Radiocarbon date}
\usage{
unCalibrate(
  calAges,
  calCurve = "intcal20",
  type = c("samples", "ages"),
  pathToCalCurves = system.file("data", package = "Bchron"),
  ...
)
}
\arguments{
\item{calAges}{Either a vector of calibrated ages (when \code{type = 'ages'}), or a vector of calibrated samples (\code{type = 'samples'})}

\item{calCurve}{he calibration curve to use. Only a single calibration curve is currently supported}

\item{type}{Either 'ages' which uncalibrates a calibrated age values without error (i.e. just a lookup on the calibration curve), or a 'samples' which estimates both an uncalibrated mean age and a standard deviation}

\item{pathToCalCurves}{The path to the calibration curve directory. Defaults to the location of the standard calibration curves given in the package}

\item{...}{Other arguments to the \code{\link{optim}} function used to match the probability distributions under \code{type = 'samples'}}
}
\value{
Either a vector of uncalibrated ages (\code{type = 'ages'}) or a list containing the estimated mean age and standard deviation (\code{type = 'samples'})
}
\description{
Uncalibrate a Radiocarbon date
}
\examples{
\donttest{
# Single version outputting just an uncalibrated age
unCalibrate(2350, type = 'ages')

# Vector version giving a vector of uncalibrated ages
unCalibrate(calAge = c(2350, 4750, 11440),
  calCurve = 'shcal20',
  type = 'ages')

# A version where calibrated standard deviations are required too
calAge = BchronCalibrate(ages = 11255,
  ageSds = 25,
  calCurves = 'intcal20')
calSampleAges = sampleAges(calAge)

# Uncalibrate the above
unCalibrate(calSampleAges,
  type = 'samples')
}
}
