/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.periodpriors;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.ArrayList;

public abstract class AbstractPeriodPriorDistribution
extends AbstractModel
implements Loggable {
    protected boolean log;
    protected double logL;
    protected double storedLogL;

    public AbstractPeriodPriorDistribution(String string, boolean bl) {
        super(string);
        this.log = bl;
    }

    public double getLogLikelihood(double[] dArray) {
        if (!this.log) {
            return this.calculateLogLikelihood(dArray);
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.log(dArray[i]);
        }
        return this.calculateLogLikelihood(dArray2);
    }

    public double getLogPosteriorProbability(double d, double d2) {
        if (!this.log) {
            return this.calculateLogPosteriorProbability(d, d2);
        }
        return this.calculateLogPosteriorProbability(Math.log(d), Math.log(d2));
    }

    public double getLogPosteriorCDF(double d, boolean bl) {
        if (!this.log) {
            return this.calculateLogPosteriorCDF(d, bl);
        }
        return this.calculateLogPosteriorCDF(Math.log(d), bl);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedLogL = this.logL;
    }

    @Override
    protected void restoreState() {
        this.logL = this.storedLogL;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public LogColumn[] getColumns() {
        ArrayList<1> arrayList = new ArrayList<1>();
        arrayList.add(new LogColumn.Abstract(this.getModelName() + "_LL"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(AbstractPeriodPriorDistribution.this.logL);
            }
        });
        return arrayList.toArray(new LogColumn[arrayList.size()]);
    }

    public abstract void reset();

    public abstract double calculateLogPosteriorProbability(double var1, double var3);

    public abstract double calculateLogPosteriorCDF(double var1, boolean var3);

    public abstract double calculateLogLikelihood(double[] var1);
}

