/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.UncertainSiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evoxml.util.DataTypeUtils;
import dr.util.Citable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class UncertainAttributePatternsParser
extends AbstractXMLObjectParser {
    public static final String ATTRIBUTE = "attribute";
    public static final String NAME = "uncertainAttributePatterns";
    public static final String LOCATION_TOKEN = "\\s";
    public static final String PROBABILITY_TOKEN = ":";
    public static final String NORMALIZE = "normalize";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new StringAttributeRule("dataType", "The data type", DataType.getRegisteredDataTypeNames(), false), new ElementRule(DataType.class)), AttributeRule.newStringRule("attribute"), AttributeRule.newBooleanRule("normalize", true), new ElementRule(TaxonList.class, "The taxon set")};

    @Override
    public String getParserName() {
        return NAME;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        String string = xMLObject.getStringAttribute(ATTRIBUTE);
        TaxonList taxonList = (TaxonList)xMLObject.getChild(TaxonList.class);
        DataType dataType = DataTypeUtils.getDataType(xMLObject);
        if (dataType == null) {
            throw new XMLParseException("dataType expected for attributePatterns element");
        }
        UncertainSiteList uncertainSiteList = new UncertainSiteList(dataType, taxonList);
        boolean bl = xMLObject.getAttribute(NORMALIZE, true);
        if (dataType == null) {
            throw new XMLParseException("dataType expected for attributePatterns element");
        }
        double[][] dArrayArray = new double[taxonList.getTaxonCount()][];
        boolean bl2 = false;
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            List<StateProbability> list;
            Taxon taxon = taxonList.getTaxon(i);
            Object object = taxon.getAttribute(string);
            if (object != null) {
                bl2 = true;
                try {
                    list = this.parseStates(object.toString(), dataType);
                }
                catch (StateParseException stateParseException) {
                    throw new XMLParseException("State or probability for attribute (" + string + ") in taxon " + taxon.getId() + " is invalid; state = \"" + stateParseException.getState() + "\" and probability =\"" + stateParseException.getProbability() + "\"");
                }
            } else {
                throw new XMLParseException("State for attribute (" + string + ") in taxon " + taxon.getId() + " is unknown.");
            }
            dArrayArray[i] = this.convertToPartials(list, dataType, bl);
        }
        if (!bl2) {
            throw new XMLParseException("The attribute (" + string + ") was missing in all taxa. Check the name of the attribute.");
        }
        uncertainSiteList.addPattern(dArrayArray);
        Logger.getLogger("dr.evolution").info("\n ---------------------------------\nCreating an uncertain attribute model for attribute \"" + string + "\"");
        Logger.getLogger("dr.evolution").info("\tIf you publish results using this model, please reference:");
        Logger.getLogger("dr.evolution").info("\t" + Citable.Utils.getCitationString(uncertainSiteList));
        Logger.getLogger("dr.evolution").info("\n");
        return uncertainSiteList;
    }

    private List<StateProbability> parseStates(String string, DataType dataType) throws StateParseException {
        String[] stringArray;
        ArrayList<StateProbability> arrayList = new ArrayList<StateProbability>();
        for (String string2 : stringArray = string.split(LOCATION_TOKEN)) {
            String[] stringArray2 = string2.split(PROBABILITY_TOKEN);
            int n = dataType.getState(stringArray2[0]);
            double d = 1.0;
            if (stringArray2.length > 1) {
                try {
                    d = Double.valueOf(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.NaN;
                }
            }
            if (n < 0 || Double.isNaN(d) || d <= 0.0 || d > 1.0) {
                throw new StateParseException(stringArray2[0], stringArray2.length == 1 ? "" : stringArray2[1]);
            }
            arrayList.add(new StateProbability(n, d));
        }
        return arrayList;
    }

    private void normalize(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
    }

    private double[] convertToPartials(List<StateProbability> list, DataType dataType, boolean bl) {
        double[] dArray = new double[dataType.getStateCount()];
        for (StateProbability stateProbability : list) {
            dArray[stateProbability.getState()] = stateProbability.getProbability();
        }
        if (bl) {
            this.normalize(dArray);
        }
        return dArray;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A site pattern defined by an attribute in a set of taxa.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }

    class StateParseException
    extends Exception {
        String state;
        String probability;

        public StateParseException(String string, String string2) {
            this.state = string;
            this.probability = string2;
        }

        public String getState() {
            return this.state;
        }

        public String getProbability() {
            return this.probability;
        }
    }

    class StateProbability {
        int state;
        double probability;

        public StateProbability(int n, double d) {
            this.state = n;
            this.probability = d;
        }

        public int getState() {
            return this.state;
        }

        public double getProbability() {
            return this.probability;
        }
    }
}

