/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.AbstractTransformedCompoundMatrix;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.missingData.MissingOps;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class CompoundEigenMatrix
extends AbstractTransformedCompoundMatrix {
    private final DenseMatrix64F transformedMatrix;
    private final double[] savedTransformedMatrix;
    private boolean compositionKnown = false;
    private final DenseMatrix64F temp = new DenseMatrix64F(this.dim, this.dim);
    public static final String NAME = "compoundEigenMatrix";
    private static final String EIGEN_VALUES = "eigenValues";
    private static final String EIGEN_VECTORS = "eigenVectors";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("eigenValues", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("eigenVectors", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)})};

        @Override
        public String getParserName() {
            return CompoundEigenMatrix.NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(CompoundEigenMatrix.EIGEN_VALUES);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(CompoundEigenMatrix.EIGEN_VECTORS);
            if (matrixParameter.getDimension() != parameter.getDimension() * (parameter.getDimension() - 1)) {
                throw new XMLParseException("Invalid parameter dimensions in `" + xMLObject.getId() + "'");
            }
            return new CompoundEigenMatrix(parameter, matrixParameter);
        }

        @Override
        public String getParserDescription() {
            return "A compound matrix parametrized by its eigen values and vectors.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return CompoundEigenMatrix.class;
        }
    };

    public CompoundEigenMatrix(Parameter parameter, MatrixParameter matrixParameter) {
        super(parameter, matrixParameter);
        this.transformedMatrix = new DenseMatrix64F(this.dim, this.dim);
        this.computeTransformedMatrix();
        this.savedTransformedMatrix = new double[this.dim * this.dim];
    }

    private void computeTransformedMatrix() {
        DenseMatrix64F denseMatrix64F = MissingOps.wrapSpherical(this.offDiagonalParameter.getParameterValues(), 0, this.dim);
        DenseMatrix64F denseMatrix64F2 = MissingOps.wrapDiagonal(this.diagonalParameter.getParameterValues(), 0, this.dim);
        CommonOps.mult(denseMatrix64F, denseMatrix64F2, this.temp);
        CommonOps.invert(denseMatrix64F);
        CommonOps.mult(this.temp, denseMatrix64F, this.transformedMatrix);
        this.compositionKnown = true;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        return this.getParameterValueUnsafe(n, n2);
    }

    private double getParameterValueUnsafe(int n, int n2) {
        if (!this.compositionKnown) {
            this.computeTransformedMatrix();
        }
        return this.transformedMatrix.get(n, n2);
    }

    @Override
    public double[] getAttributeValue() {
        this.compositionKnown = false;
        double[] dArray = new double[this.dim * this.dim];
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray[n] = this.getParameterValueUnsafe(i, j);
                ++n;
            }
        }
        return dArray;
    }

    @Override
    public double[] updateGradientDiagonal(double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] updateGradientOffDiagonal(double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    public double[] getEigenValues() {
        return this.diagonalParameter.getParameterValues();
    }

    public double[] getEigenVectors() {
        DenseMatrix64F denseMatrix64F = MissingOps.wrapSpherical(this.offDiagonalParameter.getParameterValues(), 0, this.dim);
        return denseMatrix64F.getData();
    }

    @Override
    public String getReport() {
        return new WrappedMatrix.ArrayOfArray(this.getParameterAsMatrix()).toString();
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }

    @Override
    public void fireParameterChangedEvent() {
        this.compositionKnown = false;
        super.fireParameterChangedEvent();
    }

    @Override
    public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
        this.compositionKnown = false;
        super.fireParameterChangedEvent(n, changeType);
    }

    @Override
    protected void storeValues() {
        super.storeValues();
        System.arraycopy(this.transformedMatrix.getData(), 0, this.savedTransformedMatrix, 0, this.dim * this.dim);
    }

    @Override
    protected void restoreValues() {
        super.restoreValues();
        this.transformedMatrix.setData(this.savedTransformedMatrix);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.compositionKnown = false;
        super.variableChangedEvent(variable, n, changeType);
    }
}

