/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.NormalDistribution;
import dr.math.distributions.NormalKDEDistribution;
import dr.stats.DiscreteStatistics;
import java.util.Arrays;
import java.util.Random;

public class LogTransformedNormalKDEDistribution
extends NormalKDEDistribution {
    public static final int MINIMUM_GRID_SIZE = 2048;
    public static final boolean DEBUG = false;
    private double[] backupXPoints;
    private double[] finalDensityPoints;
    private double[] backupSample;
    private double[] logSample = this.sample;
    private boolean transformIncreasing = true;

    public LogTransformedNormalKDEDistribution(Double[] doubleArray) {
        this(doubleArray, null, null, null);
    }

    public LogTransformedNormalKDEDistribution(Double[] doubleArray, int n) {
        this(doubleArray, null, null, null, 3.0, n);
    }

    private LogTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3) {
        this(doubleArray, d, d2, d3, 3.0, 2048);
    }

    public LogTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, int n) {
        this(doubleArray, d, d2, d3, 3.0, n);
    }

    private LogTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, double d4, int n) {
        super(LogTransformedNormalKDEDistribution.getLog(doubleArray), d, d2, d3);
        this.backupSample = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            this.backupSample[i] = doubleArray[i];
        }
        this.densityKnown = false;
        this.computeDensity();
    }

    private static Double[] getLog(Double[] doubleArray) {
        Double[] doubleArray2 = new Double[doubleArray.length];
        for (int i = 0; i < doubleArray2.length; ++i) {
            doubleArray2[i] = Math.log(doubleArray[i]);
        }
        return doubleArray2;
    }

    @Override
    public double getFromPoint() {
        return this.from;
    }

    @Override
    public double getToPoint() {
        return this.to;
    }

    @Override
    protected void computeDensity() {
        this.makeOrdinates();
        this.makeXGrid();
        this.transformData();
        this.transformEstimator();
        this.densityKnown = true;
    }

    private void transformEstimator() {
        this.sample = this.backupSample;
        this.setBandWidth(null);
        this.setBounds();
        if (this.lo < 0.0) {
            this.lo = DiscreteStatistics.min(this.sample);
        }
        this.backupXPoints = new double[this.xPoints.length];
        System.arraycopy(this.xPoints, 0, this.backupXPoints, 0, this.xPoints.length);
        this.makeXGrid();
        this.finalDensityPoints = new double[this.densityPoints.length];
        for (int i = 0; i < this.xPoints.length; ++i) {
            this.finalDensityPoints[i] = this.linearApproximate(this.backupXPoints, this.densityPoints, Math.log(this.xPoints[i]), 0.0, 0.0) * (1.0 / this.xPoints[i]);
        }
    }

    @Override
    protected double evaluateKernel(double d) {
        if (!this.densityKnown) {
            this.computeDensity();
        }
        return this.linearApproximate(this.xPoints, this.finalDensityPoints, d, 0.0, 0.0);
    }

    @Override
    protected void processBounds(Double d, Double d2) {
        if (d != null && d != Double.NEGATIVE_INFINITY || d2 != null && d2 != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("LogTransformedNormalKDEDistribution must be unbounded");
        }
    }

    @Override
    protected void setBandWidth(Double d) {
        this.resetIndices(this.transformIncreasing);
        super.setBandWidth(d);
    }

    public static void main(String[] stringArray) {
        Double d;
        int n;
        Object[] objectArray = new Double[10000];
        NormalDistribution normalDistribution = new NormalDistribution(0.5, 0.1);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = (Double)normalDistribution.nextRandom();
            if (!((Double)objectArray[i] < 0.0)) continue;
        }
        Arrays.sort(objectArray);
        LogTransformedNormalKDEDistribution logTransformedNormalKDEDistribution = new LogTransformedNormalKDEDistribution((Double[])objectArray);
        NormalKDEDistribution normalKDEDistribution = new NormalKDEDistribution((Double[])objectArray);
        objectArray = new Double[2000];
        normalDistribution = new NormalDistribution(0.0, 1.0);
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = (Double)normalDistribution.nextRandom();
            while ((Double)objectArray[n] < 0.0) {
                objectArray[n] = (Double)normalDistribution.nextRandom();
            }
            objectArray[n] = Math.exp((Double)objectArray[n] - Math.exp(1.0));
        }
        System.out.print("par(mfrow=c(2,2))\n\nsamples <- c(");
        for (n = 0; n < objectArray.length - 1; ++n) {
            System.out.print(objectArray[n] + ",");
        }
        System.out.println(objectArray[objectArray.length - 1] + ")\n");
        System.out.println("hist(samples, 200)\nminimum=min(samples)\nabline(v=minimum,col=2,lty=2)\n");
        System.out.println("plot(density(samples))\nabline(v=minimum,col=2,lty=2)\n");
        Arrays.sort(objectArray);
        logTransformedNormalKDEDistribution = new LogTransformedNormalKDEDistribution((Double[])objectArray);
        normalKDEDistribution = new NormalKDEDistribution((Double[])objectArray);
        System.out.print("normalKDE <- c(");
        for (n = 0; n < 1999; ++n) {
            d = 0.0 + (double)n / 1000.0;
            System.out.print(normalKDEDistribution.evaluateKernel(d) + ",");
        }
        System.out.println(normalKDEDistribution.evaluateKernel(1.999) + ")\n");
        System.out.println("index <- seq(0.0,1.999,by=0.001)");
        System.out.println("plot(index,normalKDE,type=\"l\")\nabline(v=minimum,col=2,lty=2)\n");
        System.out.print("TransKDE <- c(");
        for (n = 0; n < 1999; ++n) {
            d = 0.0 + (double)n / 1000.0;
            System.out.print(logTransformedNormalKDEDistribution.evaluateKernel(d) + ",");
        }
        System.out.println(logTransformedNormalKDEDistribution.evaluateKernel(1.999) + ")\n");
        System.out.println("plot(index,TransKDE,type=\"l\")\nabline(v=minimum,col=2,lty=2)");
        long l = System.currentTimeMillis();
        Random random = new Random(1234L);
        Double[] doubleArray = new Double[10000000];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = random.nextDouble();
        }
        LogTransformedNormalKDEDistribution logTransformedNormalKDEDistribution2 = new LogTransformedNormalKDEDistribution(doubleArray);
        for (int i = 0; i < 100; ++i) {
            logTransformedNormalKDEDistribution2.evaluateKernel(random.nextDouble());
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Time: " + (l2 - l));
    }
}

