/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

public class BandMatrix
extends AbstractBandMatrix {
    public BandMatrix(int n, int kl, int ku) {
        super(n, kl, ku);
    }

    public BandMatrix(Matrix A, int kl, int ku) {
        super(A, kl, ku);
    }

    public BandMatrix(Matrix A, int kl, int ku, boolean deep) {
        super(A, kl, ku, deep);
    }

    public BandMatrix copy() {
        return new BandMatrix(this, this.kl, this.ku);
    }

    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        Interface.blas().gbmv(BLASkernel.Transpose.NoTranspose, this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1.0, yd);
        return y;
    }

    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        Interface.blas().gbmv(BLASkernel.Transpose.Transpose, this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1.0, yd);
        return y;
    }

    public Matrix solve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        BandMatrix Af = new BandMatrix(this, this.kl, this.ku + this.kl);
        int[] ipiv = new int[this.numRows];
        int info = Interface.lapack().gbsv(this.numRows, this.kl, this.ku, X.numColumns(), Af.getData(), ipiv, Xd);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    public Matrix transpose() {
        this.checkTranspose();
        if (this.kl != this.ku) {
            throw new IllegalArgumentException("kl != ku");
        }
        for (int j = 0; j < this.numColumns; ++j) {
            for (int i = j + 1; i < Math.min(j + this.kl + 1, this.numRows); ++i) {
                double value = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, value);
            }
        }
        return this;
    }
}

