# $Id: graphEff.R 93 2010-11-21 15:29:03Z Lars $

# Funktion til beregning af graf efficiens.  Beregning sker via
# bisection hvor der itereres mellem mulige og ikke-mulige lsninger
# et LP problem hvor venstreside er som in- og output orienteret
# efficiens. blot er frste sjle erstattet af rene nuller, og G*X og
# (1/G)*Y optrder p hjresiden. Minimering af 0 s der blot sges om
# der er en mulig lsning. Da sjlen for efficiens er bar 0'er vil
# justering af efficiens ud over G ikke ske, dvs. det er kun lambdaer
# der tilpasses for at se om der er en mulig lsning.

graphEff <- function(lps, X, Y, XREF, YREF, RTS, FRONT.IDX, rlamb, oKr, 
                     TRANSPOSE=FALSE, SLACK=FALSE, FAST=FALSE, LP=FALSE) 
{
   m = dim(X)[2]  # number of inputs
   n = dim(Y)[2]  # number of outputs
   K = dim(X)[1]  # number of units, firms, DMUs
   Kr = dim(YREF)[1]  # number of units, firms, DMUs

   objval <- rep(NA,K)   # vector for the final efficiencies
   if ( FAST ) {
     lambda <- NULL
   } else {
      lambda <- matrix(NA, nrow=K, ncol=Kr) # lambdas one column per unit
   }
   set.column(lps, 1, rep(0,dim(lps)[1]))
   lpcontr <- lp.control(lps)
   tol <- lpcontr$epsilon["epsint"]
   for ( k in 1:K)  {
      if ( LP )  print(paste("Firm",k), quote=FALSE)
      # Lav bisection
      a <- 0
      b <- 2  # medfrer start med G=1
      nIter <- 0
      while ( b-a > tol && nIter < 50 )  {
         G <- (a+b)/2
         set.rhs(lps, c(-G*X[k,],Y[k,]/G), 1:(m+n))
         # if ( k==1 ) print(lps)
         status <- solve(lps)
         if (LP) print(paste("G = ",G,"(",k,"); status =",status))
         if ( status == 0 ) {
            # lsning findes
            b <- G
         } else {
            a <- G
         }
         nIter <- nIter + 1
      }
      if ( status != 0 )  {
         # Hvis den sidste vrdi af G ikke var mulig bruger vi den
         # vre grnse. Det er ndvendigt med en mulig lsning for at
         # kunne f lambdaer og duale vrdier.
         G <- b
	      set.rhs(lps, c(-G*X[k,],Y[k,]/G), 1:(m+n))
         status <- solve(lps)
	   }
      if (LP)  {
         print(paste("G = ",G,"(",k,"); status =",status))
         print(rlamb)
         print("Solution")
         print(get.variables(lps))
         print(lps)
      }
      objval[k] <- G
      if ( LP && k == 1 )  print(lps)
      if ( !FAST ) 
      if ( !FAST )  {
         sol <- get.variables(lps)
         lambda[k,] <- sol[2:(1+Kr)]
      }
   	if (LP && status==0) {
         print(paste("Objval, firm",k))
         print(get.objective(lps))
         print("Solution/varaibles")
         print(get.variables(lps))
         print("Primal solution")
         print(get.primal.solution(lps))
         print("Dual solution:")
         print(get.dual.solution(lps))
      }
   }  # loop for each firm

   e <- objval
   e[abs(e-1) < sqrt(tol)] <- 1

   if ( FAST ) { 
      return(e)
      stop("Her skulle vi ikke kunne komme i 'dea'")
   }

   if ( length(FRONT.IDX)>0 )  {
      colnames(lambda) <- paste("L",(1:oKr)[FRONT.IDX],sep="")
   } else {
      colnames(lambda) <- paste("L",1:Kr,sep="")
   }

   primal <- dual <- NULL
   ux <- vy <- NULL

   if ( TRANSPOSE ) {
      lambda <- t(lambda)
   }

   oe <- list(eff=e, lambda=lambda, objval=objval, RTS=RTS,
              primal=primal, dual=dual, ux=ux, vy=vy, gamma=gamma,
              ORIENTATION="graph", TRANSPOSE=TRANSPOSE
              # ,slack=slack_, sx=sx, sy=sy
              )
   class(oe) <- "Farrell"

   if ( SLACK ) {
      if ( TRANSPOSE )  { # Transponer tilbage hvis de blev transponeret
         X <- t(X)
         Y <- t(Y)
         XREF <- t(XREF)
         YREF <- t(YREF)
      }
      sl <- slack(X, Y, oe, XREF, YREF, FRONT.IDX, LP=LP)
      oe$slack <- sl$slack
      oe$sx <- sl$sx
      oe$sy <- sl$sy
      oe$lambda <- sl$lambda
      if (LP)  {
         print("slack fra slack:")
         print(sl$slack)
         print("slack efter slack:")
         print(oe$slack)
      }
   }

   return(oe)
}

