% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_transmrate.R
\name{plot_posterior_transmrate}
\alias{plot_posterior_transmrate}
\title{Plot the estimated age-specific transmission rate}
\usage{
plot_posterior_transmrate(object, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{object}{A dataframe from \code{\link[Bernadette]{posterior_transmrate}}.}

\item{xlab}{character; Title of x-axis.}

\item{ylab}{character; Title of y-axis.}

\item{...}{Optional arguments passed to \code{\link[ggplot2]{facet_wrap}}, \code{\link[ggplot2]{scale_x_date}} and \code{\link[ggplot2]{theme}}.}
}
\value{
A \code{ggplot} object which can be further customised using the \pkg{ggplot2} package.
}
\description{
Plot the estimated age-specific transmission rate
}
\examples{
\donttest{
if (.Platform$OS.type != "windows" || .Platform$r_arch != "i386") {
# Age-specific mortality/incidence count time series:
data(age_specific_mortality_counts)
data(age_specific_infection_counts)

# Import the age distribution for Greece in 2020:
age_distr <- age_distribution(country = "Greece", year = 2020)

# Lookup table:
lookup_table <- data.frame(Initial = age_distr$AgeGrp,
                          Mapping = c(rep("0-39",  8),
                                      rep("40-64", 5),
                                      rep("65+"  , 3)))

# Aggregate the age distribution table:
aggr_age <- aggregate_age_distribution(age_distr, lookup_table)

# Import the projected contact matrix for Greece:
conmat <- contact_matrix(country = "GRC")

# Aggregate the contact matrix:
aggr_cm <- aggregate_contact_matrix(conmat, lookup_table, aggr_age)

# Aggregate the IFR:
ifr_mapping <- c(rep("0-39", 8), rep("40-64", 5), rep("65+", 3))

aggr_age_ifr <- aggregate_ifr_react(age_distr, ifr_mapping, age_specific_infection_counts)

# Infection-to-death distribution:
ditd <- itd_distribution(ts_length  = nrow(age_specific_mortality_counts),
                         gamma_mean = 24.19231,
                         gamma_cv   = 0.3987261)

# Posterior sampling:
igbm_fit <- stan_igbm(y_data                      = age_specific_mortality_counts,
                      contact_matrix              = aggr_cm,
                      age_distribution_population = aggr_age,
                      age_specific_ifr            = aggr_age_ifr[[3]],
                      itd_distr                   = ditd,
                      likelihood_variance_type    = "quadratic",
                      prior_volatility            = normal(location = 0, scale = 1),
                      prior_nb_dispersion         = gamma(shape = 2, rate = 1),
                      algorithm_inference         = "optimizing")

post_transmrate_summary <- posterior_transmrate(igbm_fit)

# Visualise the posterior distribution of the age-specific transmission rate:
plot_posterior_transmrate(post_transmrate_summary)
}
}
}
\seealso{
\code{\link{posterior_transmrate}}.
}
