% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R
\name{edges.posterior}
\alias{edges.posterior}
\title{Estimating posterior probabilities of single edges}
\usage{
edges.posterior(MCMCchain, startstep = 200)
}
\arguments{
\item{MCMCchain}{list of square matrices with elements in \code{\{0,1\}} and representing adjacency matrices of a sample of DAGs obtained via an MCMC scheme}

\item{startstep}{(optional) indicates the index of of the first element in the list to be included as part of the sample used to calculate the posterior probabilities; all elements before startstep will be discarded as `burn-in' of the MCMC chain}
}
\value{
a square matrix with dimensions equal to the number of variables; each entry \code{[i,j]} is an estimate of the posterior probability of the edge from node \code{i} to node \code{j}
}
\description{
This function estimates the posterior probabilities of edges by averaging over a sample of DAGs
obtained via an MCMC scheme.
}
\examples{
Bostonscore<-scoreparameters(14, "bge", Boston)
\dontrun{
samplefit<-orderMCMC(14, Bostonscore, iterations=25000)
edgesposterior<-edges.posterior(samplefit$chain$incidence, startstep=300)
}
}
