% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initpar.R
\name{scoreparameters}
\alias{scoreparameters}
\title{Initialising score object}
\usage{
scoreparameters(
  n,
  scoretype = c("bge", "bde", "bdecat"),
  data,
  weightvector = NULL,
  bgnodes = NULL,
  bgepar = list(am = 1, aw = NULL),
  bdepar = list(chi = 0.5, edgepf = 2),
  bdecatpar = list(chi = 0.5, edgepf = 2),
  dbnpar = list(samestruct = TRUE, slices = 2),
  usrpar = list(pctesttype = c("bge", "bde", "bdecat")),
  edgepmat = NULL,
  nodeslabels = NULL,
  DBN = FALSE
)
}
\arguments{
\item{n}{number of nodes (variables) in the Bayesian network; for DBN n represents the number of nodes per one time slice (including static variables)}

\item{scoretype}{the score to be used to assess the DAG structure:
"bge" for Gaussian data, "bde" for binary data, 
"bdecat" for categorical data, "dbn" for dynamic Bayesian networks,
"usr" for a user defined score}

\item{data}{the data matrix with n columns (the number of variables) and a number of rows equal to the number of observations}

\item{weightvector}{(optional) a numerical vector of positive values representing the weight of each observation; should be NULL(default) for non-weighted data}

\item{bgnodes}{(optional) a numerical vector which contains numbers of columns in the data defining background nodes, background nodes are nodes which have no parents but can be parents of other nodes in the network; in case of DBNs bgnodes represent static variables which do not change over time}

\item{bgepar}{a list which contains parameters for BGe score:
\itemize{
\item am (optional) a positive numerical value, 1 by default
\item aw (optional) a positive numerical value should be more than \code{n+1}, \code{n+am+1} by default
}}

\item{bdepar}{a list which contains parameters for BDe score for binary data:
\itemize{
\item chi (optional) a positive number of prior pseudo counts used by the BDe score, 0.5 by default
\item edgepf (optional) a positive numerical value providing the edge penalization factor to be combined with the BDe score, 2 by default
}}

\item{bdecatpar}{a list which contains parameters for BDe score for categorical data:
\itemize{
\item chi (optional) a positive number of prior pseudo counts used by the BDe score, 0.5 by default
\item edgepf (optional) a positive numerical value providing the edge penalization factor to be combined with the BDe score, 2 by default
}}

\item{dbnpar}{which type of score to use for the slices
\itemize{
\item samestruct logical, when TRUE the structure of the first time slice is assumed to be the same as internal structure of all other time slices
\item slices integer representing the number of time slices in a DBN
}}

\item{usrpar}{a list which contains parameters for the user defined score
\itemize{
\item pctesttype (optional) conditional independence test ("bde","bge","bdecat","usrCItest")
\item suffStat (optional)  a list containing sufficient statistics for  the CI test
\item otherpars (optional) a list containing other parameters needed for score evaluation
}}

\item{edgepmat}{(optional) a matrix of positive numerical values providing the per edge penalization factor to be added to the score, NULL by default}

\item{nodeslabels}{(optional) a vector of characters which denote the names of nodes in the Bayesian network; by default column names of the data will be taken}

\item{DBN}{logical, when TRUE the score is initialized for a dynamic Baysian network; FALSE by default}
}
\value{
an object of class \code{scoreparameters}, which includes all necessary information for calculating the BDe/BGe score
}
\description{
This function returns an object of class scoreparameters containing the data and parameters needed for calculation of the BDe/BGe score, or a user defined score.
}
\examples{
myDAG<-pcalg::randomDAG(20, prob=0.15, lB = 0.4, uB = 2) 
myData<-pcalg::rmvDAG(200, myDAG) 
myScore<-scoreparameters(20, "bge", myData)
}
\references{
Geiger D and Heckerman D (2002). Parameter priors for directed acyclic graphical models and the characterization of several probability distributions. The Annals of Statistics 30, 1412-1440.

Kuipers J, Moffa G and Heckerman D (2014). Addendum on the scoring of Gaussian acyclic graphical models. The Annals of Statistics 42, 1689-1691.

Heckerman D and Geiger D (1995). Learning Bayesian networks: A unification for discrete and Gaussian domains. In Eleventh Conference on Uncertainty in Artificial Intelligence, pages 274-284.

Scutari M (2016). An Empirical-Bayes Score for Discrete Bayesian Networks. Journal of Machine Learning Research 52, 438-448
}
