% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdQR_hdf5}
\alias{bdQR_hdf5}
\title{QR Decomposition for HDF5-Stored Matrices}
\usage{
bdQR_hdf5(
  filename,
  group,
  dataset,
  outgroup = NULL,
  outdataset = NULL,
  thin = NULL,
  block_size = NULL,
  overwrite = NULL,
  threads = NULL
)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file containing the input matrix.}

\item{group}{Character string. Path to the group containing the input dataset.}

\item{dataset}{Character string. Name of the input dataset to decompose.}

\item{outgroup}{Character string. Optional output group path where results will be stored.
If not provided, results are stored in \verb{<input_group>/QRDec}.}

\item{outdataset}{Character string. Optional base name for output datasets. Results
will be stored as \verb{Q.'outdataset'} and \verb{R.'outdataset'}.}

\item{thin}{Logical. If TRUE, computes the reduced (thin) QR decomposition.
If FALSE (default), computes the full decomposition.}

\item{block_size}{Integer. Optional block size for blocked computation.}

\item{overwrite}{Logical. If TRUE, allows overwriting existing datasets.
Default is FALSE.}

\item{threads}{Integer. Optional number of threads for parallel computation.
If NULL, uses all available threads.}
}
\value{
List with components. If an error occurs, all string values are returned as empty strings (""):
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds_Q}{Character string with the full dataset path to the Q matrix
(orthogonal matrix). Results are written to the HDF5 file as
"Q.'outdataset'" within the specified group}
\item{ds_R}{Character string with the full dataset path to the R matrix
(upper triangular matrix). Results are written to the HDF5 file as
"R.'outdataset'" within the specified group}
}
}
\description{
Computes the QR decomposition of a matrix stored in an HDF5 file, factoring it into
a product A = QR where Q is an orthogonal matrix and R is an upper triangular matrix.
Results are stored back in the HDF5 file.
}
\details{
This function performs QR decomposition on large matrices stored in HDF5 format,
which is particularly useful for matrices too large to fit in memory. Features include:
\itemize{
\item Support for both thin and full QR decomposition
\item Blocked computation for improved performance
\item Parallel processing capabilities
\item Flexible output location specification
\item Optional overwriting of existing datasets
}
}
\examples{
\dontrun{
# Create a sample HDF5 file with a matrix
library(rhdf5)
A <- matrix(rnorm(1000), 100, 10)
h5createFile("example.h5")
h5write(A, "example.h5", "mygroup/mymatrix")

# Compute QR decomposition
bdQR_hdf5("example.h5", "mygroup", "mymatrix",
          outgroup = "mygroup/results",
          outdataset = "qr_result",
          thin = TRUE)
}

}
\seealso{
\code{\link{bdQR}} for QR decomposition of in-memory matrices
}
