% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bd_wproduct}
\alias{bd_wproduct}
\title{Weighted matrix–vector products and cross-products}
\usage{
bd_wproduct(X, w, op)
}
\arguments{
\item{X}{Numeric matrix (n x p).}

\item{w}{Numeric weight vector (length \code{n} or \code{p}), or a 1D matrix coerced to a vector.}

\item{op}{Character string (case-insensitive): one of
\code{"XtwX"/"xtwx"}, \code{"XwXt"/"xwxt"}, \code{"Xw"/"xw"}, \code{"wX"/"wx"}.}
}
\value{
Numeric matrix with dimensions depending on \code{op}:
\code{p x p} for \code{"xtwx"}, \code{n x n} for \code{"xwxt"}, and \code{n x p} for \code{"xw"}/\code{"wx"}.
}
\description{
Compute weighted operations using a diagonal weight from \code{w}:
\itemize{
\item \code{"xtwx"}: \eqn{X' diag(w) X}  (row weights; \code{length(w) = nrow(X)})
\item \code{"xwxt"}: \eqn{X diag(w) X'}  (column weights; \code{length(w) = ncol(X)})
\item \code{"xw"}  : \eqn{X diag(w)}     (column scaling; \code{length(w) = ncol(X)})
\item \code{"wx"}  : \eqn{diag(w) X}     (row scaling;    \code{length(w) = nrow(X)})
}
Inputs may be base numeric matrices .
}
\details{
\code{w} is interpreted as the diagonal of a weight matrix; its required length depends on the operation:
rows for \code{"xtwx"} and \code{"wx"}, columns for \code{"xwxt"} and \code{"xw"}.
}
\examples{
set.seed(1)
n <- 10; p <- 5
X <- matrix(rnorm(n * p), n, p)
u <- runif(n); w <- u * (1 - u)
bd_wproduct(X, w, "xtwx")  # p x p
bd_wproduct(X, w, "wx")    # n x p (row scaling)

v <- runif(p)
bd_wproduct(X, v, "xw")    # n x p (col scaling)
bd_wproduct(X, v, "xwxt")  # n x n

}
