% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BigVARObjectClass.R
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict,BigVAR.results-method}
\title{Forecast using a BigVAR.results object}
\usage{
predict(object,...)
}
\arguments{
\item{object}{BigVAR.results object from \code{cv.BigVAR}}

\item{...}{additional arguments affecting the predictions produced (e.g. \code{n.ahead})}
}
\description{
Forecast using a BigVAR.results object
}
\details{
Provides \code{n.ahead} step forecasts using the model produced by cv.BigVAR.
}
\examples{
data(Y)
Y=Y[1:100,]
Model1=constructModel(Y,p=4,struct="Basic",gran=c(50,10),verbose=FALSE)
results=cv.BigVAR(Model1)
predict(results,n.ahead=1)
}
\seealso{
\code{\link{cv.BigVAR}}
}

