% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmds.R
\name{nmds}
\alias{nmds}
\title{Creates a non-metric multidimensional scaling plot (nMDS).}
\usage{
nmds(
  x,
  dist_meth = "binary",
  k_val = 2,
  pt_size = 1,
  colours = c("dodgerblue", "black", "red", "green3", "orange", "darkblue", "gold2",
    "darkgreen", "darkred", "grey", "darkgrey", "magenta", "darkorchid", "purple",
    "brown", "coral3", "turquoise", "deeppink", "lawngreen", "deepskyblue", "tomato",
    "yellow", "yellowgreen", "royalblue", "olivedrab", "midnightblue", "indianred1",
    "darkturquoise"),
  shapes = 16,
  labs = FALSE,
  legend_pos = "right",
  include_ellipse = FALSE,
  ellipse_type = "norm",
  dimension1 = 1,
  dimension2 = 2
)
}
\arguments{
\item{x}{Consolidated binary matrix with grouping information in the second column.}

\item{dist_meth}{Distance method. Set to "binary" by default. Other options are "euclidean", "maximum", "manhattan", "canberra", or "minkowski".}

\item{k_val}{Number of dimensions for the nMDS plot. Set to 2 by default.}

\item{pt_size}{Point size for symbols on the plot. Set to 1 by default.}

\item{colours}{Vector containing colours to be assigned to groups. This can be changed to the options available in the RColorBrewer palette set (e.g. "Set1"). See <http://applied-r.com/rcolorbrewer-palettes/> for more palette options.
Alternatively, the colours can be set manually using, for example, c("red", "green", "blue"), thereby setting a colour for each group
in your dataset. There are 28 default colours that will be set automatically to your groups.}

\item{shapes}{Vector containing pch values for shapes to be used for points. The default is set to round filled circles (pch = 16).
To change this to custom shapes, use something like c(2,3,16) for each group you have in the dataset.}

\item{labs}{Indicate whether labels should appear on the graph or not (TRUE or FALSE). Default = FALSE.}

\item{legend_pos}{Indicate the position of the legend. Default = "right", but other options are "left", "bottom", "top", or "none"}

\item{include_ellipse}{Indicate whether ellipses should be included around groups. Default = FALSE.}

\item{ellipse_type}{Select the type of ellipses to include around groups. Options are "convex", "confidence", "t", "norm", and "euclid". See the ggpubr::ggscatter() function documentation for more details.}

\item{dimension1}{Indicate the first dimension to plot (1, 2, or 3) for the x axis. If k = 2, the first two dimensions will automatically be plotted. If k = 3, select between the three.}

\item{dimension2}{Indicate the second dimension to plot (1, 2, or 3) for the y axis}
}
\value{
nMDS plot.
}
\description{
Creates an nMDS plot from a consolidated binary matrix with grouping information. Colours and shapes of plotted points need to be specified. For example, if there are two groups, then: clrs = c("red", "blue"), sh = c(16, 16). This assigns red to the first group name, and blue to the second. Both will have a pch shape of 16 (round dot). These two vectors are then passed to the function nmds() as: colours = clrs, shapes = sh.
}
\examples{
 mat = BinMatInput_ordination
group.names(mat)
clrs = c("red", "green", "black")
shps = c(16,10,12)
nmds(mat, colours = clrs, shapes = shps, labs = TRUE, include_ellipse = TRUE)

}
