% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{vcfapply}
\alias{vcfapply}
\title{Apply a function to each SNP in a vcf file}
\usage{
vcfapply(vcfinfo, func, ...)
}
\arguments{
\item{vcfinfo}{List with information about the
vcf file returned from getvcfinfo}

\item{func}{A user supplied function to apply
to the data for each snp. The function must be
provide with the following parameters, dosage,
p0, p1, and p2, where dosage is the dosage values
for each subject and p0, p1, and p2 are the
probabilities that a subject has zero, one,
and two copies of the alternate allele,
respectively.}

\item{...}{Additional parameters needed by the
user supplied function}
}
\value{
A list with length equal to the number
of SNPs in the vcf file. Each element
of the list is the value returned by the user
supplied function
}
\description{
A routine that reads in the SNP data serially
from a vcf file and applies a user specified
function to the data.
}
\examples{
# Get information about a vcf file

vcf1afile <- system.file("extdata", "set1a.vcf", package = "BinaryDosage")
vcfinfo <- getvcfinfo(vcffiles = vcf1afile)

# Apply the getaaf, get alternate allele frequency, function
# to all the SNPs in the vcf file

aaf <- vcfapply(vcfinfo = vcfinfo,
                func = BinaryDosage:::getaaf)
}
\seealso{
Other Iterating functions: 
\code{\link{bdapply}()},
\code{\link{genapply}()}
}
\concept{Iterating functions}
