% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{SeuratToExpressionSet}
\alias{SeuratToExpressionSet}
\title{Converts Seurat object to Expression Set}
\usage{
SeuratToExpressionSet(seurat.object, delimiter, position,
  version = c("v2", "v3"))
}
\arguments{
\item{seurat.object}{Seurat object with attributes \emph{raw.data},
\emph{ident}, and \emph{cell.names}}

\item{delimiter}{Character to split cell names with to find individual ID.}

\item{position}{Integer indicating 1-indexed position of individual ID after
splitting cell name with \emph{delimiter}.}

\item{version}{Character string. Either "v2" or "v3. Seurat version used to
create Seurat object.}
}
\value{
sc.eset Expression set containing relevant phenotype and individual
  data, \emph{cellType} and \emph{SubjectName}.
}
\description{
`SeuratToExpressionSet()` returns an Expression Set with phenotype data
indicating cell type (cellType) and individual (SubjectName) for each cell
in a Seurat object. Raw counts data is used for assay data.
}
\details{
Note that the \emph{Seurat} and \emph{Biobase} libraries should be attached
before running this function. The \emph{delimiter} and \emph{position} 
arguments are used to infer the individual ID from the cell ID. For example,
a delimiter of "-" and position of "2" indicates that the individual ID for
the cell ID \strong{ACTG-2} would be \strong{2}.
}
\examples{
\donttest{
  library(Seurat)
  library(Biobase)

  # We make a class to emulate a Seurat v2 object for illustration only
  setClass("testSeuratv2", representation(cell.names = "character",
                                          ident = "character",
                                          raw.data = "matrix"))
  sc.counts <- matrix(0,nrow=3,ncol=3)
  # These barcodes correspond to a delimiter of "-" and position 2 for individual id.
  test.cell.names <- c("ATCG-1", "TAGC-2", "GTCA-3")
  test.ident <- c("cell type a", "cell type b", "cell type c")
  names(test.ident) <- test.cell.names
  colnames(sc.counts) <- test.cell.names
  test.seurat.obj <- new("testSeuratv2",
                         cell.names=test.cell.names,
                         ident=test.ident,
                         raw.data=sc.counts)

  single.cell.expression.set <- SeuratToExpressionSet(test.seurat.obj, delimiter='-',
                                                      position=2, version="v2")
}

}
